/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.rjmx.internal;

import com.jrockit.mc.rjmx.RJMXPlugin;
import com.jrockit.mc.rjmx.internal.SyntheticAttributeRepository;
import com.jrockit.mc.rjmx.internal.SyntheticNotificationRepository;
import com.jrockit.mc.rjmx.subscription.internal.AttributeValueToolkit;
import java.io.IOException;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.InvalidAttributeValueException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServerConnection;
import javax.management.NotCompliantMBeanException;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.QueryExp;
import javax.management.ReflectionException;

public final class MCMBeanServerConnection
implements MBeanServerConnection {
    private final SyntheticAttributeRepository attributeRepository;
    private final SyntheticNotificationRepository notificationRepository;
    private final MBeanServerConnection delegate;

    public MCMBeanServerConnection(MBeanServerConnection delegate) {
        this.delegate = delegate;
        this.attributeRepository = new SyntheticAttributeRepository(this);
        this.notificationRepository = new SyntheticNotificationRepository(this);
        this.attributeRepository.initializeFromExtensions();
        this.notificationRepository.initializeFromExtensions();
    }

    @Override
    public ObjectInstance createMBean(String className, ObjectName name) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, IOException {
        return this.delegate.createMBean(className, name);
    }

    @Override
    public ObjectInstance createMBean(String className, ObjectName name, ObjectName loaderName) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException, IOException {
        return this.delegate.createMBean(className, name, loaderName);
    }

    @Override
    public ObjectInstance createMBean(String className, ObjectName name, Object[] params, String[] signature) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, IOException {
        return this.delegate.createMBean(className, name, params, signature);
    }

    @Override
    public ObjectInstance createMBean(String className, ObjectName name, ObjectName loaderName, Object[] params, String[] signature) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException, IOException {
        return this.delegate.createMBean(className, name, loaderName, params, signature);
    }

    @Override
    public void unregisterMBean(ObjectName name) throws InstanceNotFoundException, MBeanRegistrationException, IOException {
        this.delegate.unregisterMBean(name);
    }

    @Override
    public ObjectInstance getObjectInstance(ObjectName name) throws InstanceNotFoundException, IOException {
        ObjectInstance instance = this.delegate.getObjectInstance(name);
        if (instance == null) {
            instance = this.attributeRepository.getObjectInstance(name);
        }
        if (instance == null) {
            instance = this.notificationRepository.getObjectInstance(name);
        }
        return instance;
    }

    @Override
    public Set<ObjectInstance> queryMBeans(ObjectName name, QueryExp query) throws IOException {
        return this.unify(this.delegate.queryMBeans(name, query), this.unify(this.attributeRepository.queryMBeans(name, query), this.notificationRepository.queryMBeans(name, query)));
    }

    @Override
    public Set<ObjectName> queryNames(ObjectName name, QueryExp query) throws IOException {
        return this.unify(this.delegate.queryNames(name, query), this.unify(this.attributeRepository.queryNames(name, query), this.notificationRepository.queryNames(name, query)));
    }

    @Override
    public boolean isRegistered(ObjectName name) throws IOException {
        return this.delegate.isRegistered(name) || this.attributeRepository.isRegistered(name) || this.notificationRepository.isRegistered(name);
    }

    @Override
    public Integer getMBeanCount() throws IOException {
        return this.queryNames(null, null).size();
    }

    @Override
    public Object getAttribute(ObjectName name, String attribute) throws MBeanException, AttributeNotFoundException, InstanceNotFoundException, ReflectionException, IOException {
        if (this.attributeRepository.hasAttribute(name, attribute)) {
            return this.attributeRepository.getAttribute(name, attribute);
        }
        return AttributeValueToolkit.getAttribute(this.delegate, name, attribute);
    }

    @Override
    public AttributeList getAttributes(ObjectName name, String[] attributes) throws InstanceNotFoundException, ReflectionException, IOException {
        AttributeList resultList = this.attributeRepository.getExistingAttributes(name, attributes);
        if (resultList.size() == attributes.length) {
            return resultList;
        }
        if (resultList.size() > 0) {
            attributes = this.filterFoundAttributes(attributes, resultList);
            resultList.addAll(AttributeValueToolkit.getAttributes(this.delegate, name, Arrays.asList(attributes)));
            return resultList;
        }
        return AttributeValueToolkit.getAttributes(this.delegate, name, Arrays.asList(attributes));
    }

    private String[] filterFoundAttributes(String[] attributes, AttributeList attributeList) {
        ArrayList<String> filteredAttributes = new ArrayList<String>(Arrays.asList(attributes));
        for (Object obj : attributeList) {
            Attribute attribute = (Attribute)obj;
            filteredAttributes.remove(attribute.getName());
        }
        attributes = filteredAttributes.toArray(new String[filteredAttributes.size()]);
        return attributes;
    }

    @Override
    public void setAttribute(ObjectName name, Attribute attribute) throws InstanceNotFoundException, AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException, IOException {
        if (this.attributeRepository.hasAttribute(name, attribute.getName())) {
            this.attributeRepository.setAttribute(name, attribute);
        } else {
            AttributeValueToolkit.setAttribute(this.delegate, name, attribute);
        }
    }

    @Override
    public AttributeList setAttributes(ObjectName name, AttributeList attributes) throws InstanceNotFoundException, ReflectionException, IOException {
        AttributeList resultList = this.attributeRepository.setExistingAttributes(name, attributes);
        if (resultList.size() == attributes.size()) {
            return resultList;
        }
        if (resultList.size() > 0) {
            attributes = this.filterFoundAttributes(attributes, resultList);
            resultList.addAll(this.delegate.setAttributes(name, attributes));
            return resultList;
        }
        return AttributeValueToolkit.setAttributes(this.delegate, name, attributes);
    }

    private AttributeList filterFoundAttributes(AttributeList attributes, AttributeList resultList) {
        AttributeList filteredAttributes = new AttributeList();
        for (Object obj : attributes) {
            boolean add = true;
            Attribute attribute = (Attribute)obj;
            for (Object result : resultList) {
                Attribute resultAttribute = (Attribute)result;
                if (!attribute.getName().equals(resultAttribute.getName())) continue;
                add = false;
                break;
            }
            if (!add) continue;
            filteredAttributes.add(attribute);
        }
        return filteredAttributes;
    }

    @Override
    public Object invoke(ObjectName name, String operationName, Object[] params, String[] signature) throws InstanceNotFoundException, MBeanException, ReflectionException, IOException {
        this.logInvokeMessage(name, operationName, params);
        return this.delegate.invoke(name, operationName, params, signature);
    }

    private void logInvokeMessage(ObjectName name, String operationName, Object[] params) {
        if (Boolean.getBoolean("com.jrockit.mc.debug")) {
            if (params == null) {
                RJMXPlugin.getDefault().getLogger().log(Level.FINE, String.format("Invoking operation %s on %s", operationName, name));
            } else {
                RJMXPlugin.getDefault().getLogger().log(Level.FINE, String.format("Invoking operation %s on %s, with parameters %s", operationName, name, this.toString(params)));
            }
        }
    }

    private Object toString(Object[] params) {
        StringBuilder builder = new StringBuilder();
        Object[] objectArray = params;
        int n = params.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            builder.append(o.toString());
            builder.append(' ');
            ++n2;
        }
        return builder.toString();
    }

    @Override
    public String getDefaultDomain() throws IOException {
        return this.delegate.getDefaultDomain();
    }

    @Override
    public String[] getDomains() throws IOException {
        return this.unify(this.unify(this.notificationRepository.getDomains(), this.attributeRepository.getDomains(), String.class), this.delegate.getDomains(), String.class);
    }

    @Override
    public void addNotificationListener(ObjectName name, NotificationListener listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException, IOException {
        if (this.notificationRepository.hasNotification(name)) {
            this.notificationRepository.addNotificationListener(name, listener, filter, handback);
            this.tryRegisteringListener(name, listener, filter, handback);
        } else {
            this.delegate.addNotificationListener(name, listener, filter, handback);
        }
    }

    private void tryRegisteringListener(ObjectName name, NotificationListener listener, NotificationFilter filter, Object handback) throws IOException, InstanceNotFoundException {
        try {
            if (!this.delegate.isRegistered(name)) {
                return;
            }
            MBeanNotificationInfo[] infos = this.delegate.getMBeanInfo(name).getNotifications();
            if (infos != null && infos.length > 0) {
                try {
                    this.delegate.addNotificationListener(name, listener, filter, handback);
                }
                catch (Exception exception) {}
            }
        }
        catch (IntrospectionException e) {
            RJMXPlugin.getDefault().getLogger().log(Level.WARNING, "Could not add listener!", e);
        }
        catch (ReflectionException e) {
            RJMXPlugin.getDefault().getLogger().log(Level.WARNING, "Could not add listener!", e);
        }
    }

    @Override
    public void addNotificationListener(ObjectName name, ObjectName listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException, IOException {
        if (this.notificationRepository.hasNotification(name)) {
            this.notificationRepository.addNotificationListener(name, listener, filter, handback);
            this.tryRegisteringListener(name, listener, filter, handback);
        } else {
            this.delegate.addNotificationListener(name, listener, filter, handback);
        }
    }

    private void tryRegisteringListener(ObjectName name, ObjectName listener, NotificationFilter filter, Object handback) throws IOException, InstanceNotFoundException {
        try {
            if (!this.delegate.isRegistered(name)) {
                return;
            }
            MBeanNotificationInfo[] infos = this.delegate.getMBeanInfo(name).getNotifications();
            if (infos != null && infos.length > 0) {
                try {
                    this.delegate.addNotificationListener(name, listener, filter, handback);
                }
                catch (Exception exception) {}
            }
        }
        catch (IntrospectionException e) {
            RJMXPlugin.getDefault().getLogger().log(Level.WARNING, "Could not add listener!", e);
        }
        catch (ReflectionException e) {
            RJMXPlugin.getDefault().getLogger().log(Level.WARNING, "Could not add listener!", e);
        }
    }

    @Override
    public void removeNotificationListener(ObjectName name, ObjectName listener) throws InstanceNotFoundException, ListenerNotFoundException, IOException {
        if (this.notificationRepository.hasNotification(name)) {
            this.notificationRepository.removeNotificationListener(name, listener);
            this.tryRemoveListener(name, listener);
        } else {
            this.delegate.removeNotificationListener(name, listener);
        }
    }

    private void tryRemoveListener(ObjectName name, ObjectName listener) throws IOException, InstanceNotFoundException {
        try {
            if (!this.delegate.isRegistered(name)) {
                return;
            }
            MBeanNotificationInfo[] infos = this.delegate.getMBeanInfo(name).getNotifications();
            if (infos != null && infos.length > 0) {
                try {
                    this.delegate.removeNotificationListener(name, listener);
                }
                catch (Exception exception) {}
            }
        }
        catch (IntrospectionException e) {
            RJMXPlugin.getDefault().getLogger().log(Level.WARNING, "Could not add listener!", e);
        }
        catch (ReflectionException e) {
            RJMXPlugin.getDefault().getLogger().log(Level.WARNING, "Could not add listener!", e);
        }
    }

    @Override
    public void removeNotificationListener(ObjectName name, ObjectName listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException, ListenerNotFoundException, IOException {
        if (this.notificationRepository.hasNotification(name)) {
            this.notificationRepository.removeNotificationListener(name, listener, filter, handback);
            this.tryRemoveListener(name, listener, filter, handback);
        } else {
            this.delegate.removeNotificationListener(name, listener, filter, handback);
        }
    }

    private void tryRemoveListener(ObjectName name, ObjectName listener, NotificationFilter filter, Object handback) throws IOException, InstanceNotFoundException {
        try {
            if (!this.delegate.isRegistered(name)) {
                return;
            }
            MBeanNotificationInfo[] infos = this.delegate.getMBeanInfo(name).getNotifications();
            if (infos != null && infos.length > 0) {
                try {
                    this.delegate.removeNotificationListener(name, listener);
                }
                catch (Exception exception) {}
            }
        }
        catch (IntrospectionException e) {
            RJMXPlugin.getDefault().getLogger().log(Level.WARNING, "Could not add listener!", e);
        }
        catch (ReflectionException e) {
            RJMXPlugin.getDefault().getLogger().log(Level.WARNING, "Could not add listener!", e);
        }
    }

    @Override
    public void removeNotificationListener(ObjectName name, NotificationListener listener) throws InstanceNotFoundException, ListenerNotFoundException, IOException {
        if (this.notificationRepository.hasNotification(name)) {
            this.notificationRepository.removeNotificationListener(name, listener);
            this.tryRemoveListener(name, listener);
        } else {
            this.delegate.removeNotificationListener(name, listener);
        }
    }

    private void tryRemoveListener(ObjectName name, NotificationListener listener) throws IOException, InstanceNotFoundException {
        try {
            if (!this.delegate.isRegistered(name)) {
                return;
            }
            MBeanNotificationInfo[] infos = this.delegate.getMBeanInfo(name).getNotifications();
            if (infos != null && infos.length > 0) {
                try {
                    this.delegate.removeNotificationListener(name, listener);
                }
                catch (Exception exception) {}
            }
        }
        catch (IntrospectionException e) {
            RJMXPlugin.getDefault().getLogger().log(Level.WARNING, "Could not add listener!", e);
        }
        catch (ReflectionException e) {
            RJMXPlugin.getDefault().getLogger().log(Level.WARNING, "Could not add listener!", e);
        }
    }

    @Override
    public void removeNotificationListener(ObjectName name, NotificationListener listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException, ListenerNotFoundException, IOException {
        if (this.notificationRepository.hasNotification(name)) {
            this.notificationRepository.removeNotificationListener(name, listener, filter, handback);
            this.tryRemoveListener(name, listener, filter, handback);
        } else {
            this.delegate.removeNotificationListener(name, listener, filter, handback);
        }
    }

    private void tryRemoveListener(ObjectName name, NotificationListener listener, NotificationFilter filter, Object handback) throws IOException, InstanceNotFoundException {
        try {
            if (!this.delegate.isRegistered(name)) {
                return;
            }
            MBeanNotificationInfo[] infos = this.delegate.getMBeanInfo(name).getNotifications();
            if (infos != null && infos.length > 0) {
                try {
                    this.delegate.removeNotificationListener(name, listener);
                }
                catch (Exception exception) {}
            }
        }
        catch (IntrospectionException e) {
            RJMXPlugin.getDefault().getLogger().log(Level.WARNING, "Could not add listener!", e);
        }
        catch (ReflectionException e) {
            RJMXPlugin.getDefault().getLogger().log(Level.WARNING, "Could not add listener!", e);
        }
    }

    @Override
    public MBeanInfo getMBeanInfo(ObjectName name) throws InstanceNotFoundException, IntrospectionException, ReflectionException, IOException {
        boolean hasSyntheticAttribute = this.attributeRepository.isRegistered(name);
        boolean hasSyntheticNotification = this.notificationRepository.isRegistered(name);
        if (!hasSyntheticAttribute && !hasSyntheticNotification) {
            return this.delegate.getMBeanInfo(name);
        }
        return this.unifyWithDelegateMBeanInfo(name, this.unifySyntheticMBeanInfo(name));
    }

    private MBeanInfo unifySyntheticMBeanInfo(ObjectName name) throws IntrospectionException, InstanceNotFoundException, ReflectionException {
        if (!this.notificationRepository.isRegistered(name)) {
            return this.attributeRepository.getMBeanInfo(name);
        }
        if (!this.attributeRepository.isRegistered(name)) {
            return this.notificationRepository.getMBeanInfo(name);
        }
        return this.unifyMBeanInfo(this.notificationRepository.getMBeanInfo(name), this.attributeRepository.getMBeanInfo(name));
    }

    private MBeanInfo unifyWithDelegateMBeanInfo(ObjectName name, MBeanInfo syntheticMBeanInfo) throws IOException, InstanceNotFoundException, IntrospectionException, ReflectionException {
        if (!this.delegate.isRegistered(name)) {
            return syntheticMBeanInfo;
        }
        return this.unifyMBeanInfo(syntheticMBeanInfo, this.delegate.getMBeanInfo(name));
    }

    private MBeanInfo unifyMBeanInfo(MBeanInfo synthetic, MBeanInfo real) {
        String description = real.getDescription();
        if (description == null || description.length() == 0) {
            description = synthetic.getDescription();
        }
        description = description != null && description.length() > 0 ? String.valueOf(description) + " [Extended with synthetic attribute(s)]" : null;
        String className = real.getClassName();
        return new MBeanInfo(className, description, this.unify(synthetic.getAttributes(), real.getAttributes(), MBeanAttributeInfo.class), real.getConstructors(), real.getOperations(), this.unify(synthetic.getNotifications(), real.getNotifications(), MBeanNotificationInfo.class));
    }

    @Override
    public boolean isInstanceOf(ObjectName name, String className) throws InstanceNotFoundException, IOException {
        if (this.delegate.isRegistered(name)) {
            return this.delegate.isInstanceOf(name, className);
        }
        if (this.attributeRepository.isRegistered(name)) {
            return this.attributeRepository.isInstanceOf(name, className);
        }
        if (this.notificationRepository.isRegistered(name)) {
            return this.notificationRepository.isInstanceOf(name, className);
        }
        return this.delegate.isInstanceOf(name, className);
    }

    private <T> T[] unify(T[] masterArray, T[] slaveArray, Class<T> arrayType) {
        ArrayList<T> unified = new ArrayList<T>(masterArray.length + slaveArray.length);
        T[] TArray = masterArray;
        int n = masterArray.length;
        int n2 = 0;
        while (n2 < n) {
            T master = TArray[n2];
            unified.add(master);
            ++n2;
        }
        TArray = slaveArray;
        n = slaveArray.length;
        n2 = 0;
        while (n2 < n) {
            T slave = TArray[n2];
            if (!unified.contains(slave)) {
                unified.add(slave);
            }
            ++n2;
        }
        T[] unifiedArray = this.createArray(arrayType, unified.size());
        return unified.toArray(unifiedArray);
    }

    private <T> T[] createArray(Class<T> componentType, int size) {
        Object[] array = (Object[])Array.newInstance(componentType, size);
        return array;
    }

    private <T> Set<T> unify(Set<T> masterSet, Set<T> slaveSet) {
        HashSet<T> unifiedSet = new HashSet<T>();
        unifiedSet.addAll(masterSet);
        unifiedSet.addAll(slaveSet);
        return unifiedSet;
    }

    public void dispose() {
        this.notificationRepository.dispose();
        this.attributeRepository.dispose();
    }
}

