/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.rjmx.services.flr;

import com.jrockit.mc.rjmx.services.flr.IRecordingDescriptor;
import java.util.Date;
import java.util.List;

public final class FlightRecorderToolkit {
    private FlightRecorderToolkit() {
        throw new AssertionError((Object)"Not to be instantiated!");
    }

    public static IRecordingDescriptor getDescriptorByName(List<IRecordingDescriptor> descriptors, String name) {
        if (name == null) {
            return null;
        }
        for (IRecordingDescriptor descriptor : descriptors) {
            if (!name.equals(descriptor.getName())) continue;
            return descriptor;
        }
        return null;
    }

    public static IRecordingDescriptor getDescriptorByID(IRecordingDescriptor[] descriptors, Integer id) {
        if (id == null) {
            return null;
        }
        IRecordingDescriptor[] iRecordingDescriptorArray = descriptors;
        int n = descriptors.length;
        int n2 = 0;
        while (n2 < n) {
            IRecordingDescriptor descriptor = iRecordingDescriptorArray[n2];
            if (id.intValue() == descriptor.getId().intValue()) {
                return descriptor;
            }
            ++n2;
        }
        return null;
    }

    public static IRecordingDescriptor getDescriptorByTimerange(List<IRecordingDescriptor> descriptors, Long timerange) {
        if (timerange == null) {
            return null;
        }
        long now = System.currentTimeMillis();
        long desiredStartTime = now - timerange;
        long bestStartTime = Long.MAX_VALUE;
        IRecordingDescriptor bestMatchingDescriptor = null;
        for (IRecordingDescriptor descriptor : descriptors) {
            if (descriptor.getState() != IRecordingDescriptor.RecordingState.RUNNING) continue;
            long dataStartTime = Long.MAX_VALUE;
            Date dataStart = descriptor.getDataStartTime();
            if (dataStart != null) {
                dataStartTime = dataStart.getTime();
                if (dataStartTime <= desiredStartTime) {
                    return descriptor;
                }
            } else {
                Date recordingStart = descriptor.getStartTime();
                if (recordingStart != null) {
                    dataStartTime = recordingStart.getTime();
                    if (descriptor.getMaxAge() > 0L) {
                        dataStartTime = Math.max(dataStartTime, now - descriptor.getMaxAge());
                    }
                } else if (bestMatchingDescriptor == null) {
                    bestMatchingDescriptor = descriptor;
                }
            }
            if (dataStartTime >= bestStartTime) continue;
            bestMatchingDescriptor = descriptor;
            bestStartTime = dataStartTime;
        }
        return bestMatchingDescriptor;
    }
}

