/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.rjmx.services.internal;

import com.jrockit.mc.rjmx.subscription.IMRIMetaData;
import com.jrockit.mc.rjmx.subscription.IMRIMetaDataService;
import com.jrockit.mc.rjmx.subscription.IMRITransformation;
import com.jrockit.mc.rjmx.subscription.MRI;
import com.jrockit.mc.rjmx.subscription.internal.MRITransformationToolkit;
import java.util.Properties;

public abstract class AbstractSingleMRITransformation
implements IMRITransformation {
    private static final String ATTRIBUTE_PROPERTY = "attribute";
    private static final String DISPLAY_NAME_PROPERTY = "displayName";
    private Properties m_transformationProperties;
    private MRI m_attribute;

    @Override
    public void setProperties(Properties properties) {
        this.m_transformationProperties = properties;
        this.m_attribute = MRI.createFromQualifiedName(this.m_transformationProperties.getProperty(ATTRIBUTE_PROPERTY));
    }

    @Override
    public MRI[] getAttributes() {
        return new MRI[]{this.m_attribute};
    }

    @Override
    public void extendMetaData(IMRIMetaDataService metaDataService, IMRIMetaData metaData) {
        MRITransformationToolkit.forwardMetaData(metaDataService, metaData.getMRI(), metaDataService.getMetaData(this.m_attribute), this.getDisplayNamePattern());
    }

    protected String getDisplayNamePattern() {
        return this.m_transformationProperties.getProperty(DISPLAY_NAME_PROPERTY);
    }

    protected Number subtract(Number minuend, Number subtrahend) {
        if (!minuend.getClass().equals(subtrahend.getClass())) {
            throw new IllegalArgumentException("Different type classes!");
        }
        if (minuend instanceof Integer) {
            return minuend.intValue() - subtrahend.intValue();
        }
        if (minuend instanceof Long) {
            return minuend.longValue() - subtrahend.longValue();
        }
        if (minuend instanceof Byte) {
            return (byte)(minuend.intValue() - subtrahend.intValue());
        }
        if (minuend instanceof Short) {
            return (short)(minuend.intValue() - subtrahend.intValue());
        }
        if (minuend instanceof Float) {
            return Float.valueOf(minuend.floatValue() - subtrahend.floatValue());
        }
        return minuend.doubleValue() - subtrahend.doubleValue();
    }
}

