/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.rjmx.triggers.actions.internal;

import com.jrockit.mc.rjmx.IConnectionHandle;
import com.jrockit.mc.rjmx.RJMXPlugin;
import com.jrockit.mc.rjmx.triggers.TriggerAction;
import com.jrockit.mc.rjmx.triggers.TriggerEvent;
import java.util.logging.Level;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;

public class TriggerActionHPROF
extends TriggerAction {
    private static final ObjectName HOTSPOT;
    private static final String HPROF_OPERATION_NAME = "dumpHeap";

    static {
        ObjectName hs = null;
        try {
            hs = new ObjectName("com.sun.management:type=HotSpotDiagnostic");
        }
        catch (Exception e) {
            System.out.println("Could not create the HotSpotDiagnostic MBean ObjectName!");
            e.printStackTrace();
        }
        HOTSPOT = hs;
    }

    @Override
    public void handleNotificationEvent(TriggerEvent e) {
        String fileName = this.getSetting("filename").getString();
        Boolean onlyLive = this.getSetting("only_live").getBoolean();
        if (onlyLive == null) {
            onlyLive = Boolean.TRUE;
        }
        this.dumpHeap(e.getSource(), fileName, onlyLive);
    }

    private void dumpHeap(IConnectionHandle connectionHandle, String fileName, Boolean onlyLive) {
        MBeanServerConnection service = connectionHandle.getServiceOrDummy(MBeanServerConnection.class);
        try {
            service.invoke(HOTSPOT, HPROF_OPERATION_NAME, new Object[]{fileName, onlyLive}, new String[]{String.class.getName(), Boolean.TYPE.getName()});
            RJMXPlugin.getDefault().getLogger().log(Level.INFO, "HPROF heap dump triggered to file " + fileName);
        }
        catch (Exception e) {
            RJMXPlugin.getDefault().getLogger().log(Level.SEVERE, "Could not invoke the hprof action!", e);
        }
    }

    @Override
    public boolean supportsAction(IConnectionHandle handle) {
        MBeanServerConnection service = handle.getServiceOrNull(MBeanServerConnection.class);
        if (service == null) {
            return false;
        }
        return this.hasHProfDumpOperation(service);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean hasHProfDumpOperation(MBeanServerConnection service) {
        try {
            MBeanInfo info = service.getMBeanInfo(HOTSPOT);
            MBeanOperationInfo[] mBeanOperationInfoArray = info.getOperations();
            int n = mBeanOperationInfoArray.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return false;
                }
                MBeanOperationInfo operation = mBeanOperationInfoArray[n2];
                if (operation.getName().equals(HPROF_OPERATION_NAME) && this.hasHProfDumpSignature(operation.getSignature())) {
                    return true;
                }
                ++n2;
            }
        }
        catch (Exception e) {
            return false;
        }
    }

    private boolean hasHProfDumpSignature(MBeanParameterInfo[] parameters) {
        return parameters.length == 2 && parameters[0].getType().equals(String.class.getName()) && parameters[1].getType().equals(Boolean.TYPE.getName());
    }
}

