/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.rjmx.triggers.internal;

import com.jrockit.mc.common.IDescribable;
import com.jrockit.mc.common.xml.XmlToolkit;
import com.jrockit.mc.rjmx.triggers.TriggerEvent;
import com.jrockit.mc.rjmx.triggers.internal.AbstractNotificationConstraint;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.Element;

public final class NotificationConstraintDateRange
extends AbstractNotificationConstraint
implements IDescribable {
    private static final Logger LOGGER = Logger.getLogger("com.jrockit.mc.rjmx");
    private static final String XML_ELEMENT_DATE_FROM = "date_from";
    private static final String XML_ELEMENT_DATE_TO = "date_to";
    public static final String NAME = "Date span";
    public static final String DESCRIPTION = "A constraint that allows notification only if the issue date of the event is within the date range (inclusive).";
    private Date m_dateFrom;
    private Date m_dateTo;
    private final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd");

    public NotificationConstraintDateRange() {
        this(new Date(), new Date());
    }

    public NotificationConstraintDateRange(Date from, Date to) {
        this.setDateFrom(from);
        this.setDateTo(to);
    }

    @Override
    public boolean isValid(TriggerEvent e) {
        long time = e.getCreationTime().getTime();
        return this.validateDate(time);
    }

    private boolean validateDate(long time) {
        return time >= this.m_dateFrom.getTime() && time <= this.m_dateTo.getTime();
    }

    public Date getDateFrom() {
        return this.m_dateFrom;
    }

    public void setDateFrom(Date dateFrom) {
        this.m_dateFrom = dateFrom;
    }

    public Date getDateTo() {
        return this.m_dateTo;
    }

    public void setDateTo(Date dateTo) {
        this.m_dateTo = dateTo;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String getDescription() {
        return DESCRIPTION;
    }

    private SimpleDateFormat getSimpleDateFormat() {
        return this.DATE_FORMAT;
    }

    public String getExtendedInfo() {
        StringBuffer buf = new StringBuffer();
        buf.append(" From = ");
        buf.append(this.DATE_FORMAT.format(this.getDateFrom()));
        buf.append(" To = ");
        buf.append(this.DATE_FORMAT.format(this.getDateTo()));
        return buf.toString();
    }

    @Override
    public void initializeFromXml(Element node) {
        String fromDate = XmlToolkit.getSetting((Element)node, (String)XML_ELEMENT_DATE_FROM, null);
        String toDate = XmlToolkit.getSetting((Element)node, (String)XML_ELEMENT_DATE_TO, null);
        try {
            Date from = this.getSimpleDateFormat().parse(fromDate);
            Date to = this.getSimpleDateFormat().parse(toDate);
            this.setDateFrom(from);
            this.setDateTo(to);
        }
        catch (ParseException e) {
            LOGGER.log(Level.SEVERE, "Could not initialize constraint from XML!", e);
        }
    }

    @Override
    public void exportToXml(Element constraintNode) {
        XmlToolkit.setSetting((Element)constraintNode, (String)XML_ELEMENT_DATE_FROM, (String)this.getSimpleDateFormat().format(this.getDateFrom()));
        XmlToolkit.setSetting((Element)constraintNode, (String)XML_ELEMENT_DATE_TO, (String)this.getSimpleDateFormat().format(this.getDateTo()));
    }
}

