/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.internal.parser.binary;

import com.jrockit.mc.flightrecorder.internal.parser.binary.InvalidFlrFileException;
import com.jrockit.mc.flightrecorder.internal.parser.binary.LongParser;
import com.jrockit.mc.flightrecorder.internal.parser.binary.Offset;
import com.jrockit.mc.flightrecorder.internal.parser.binary.ProducerParser;
import com.jrockit.mc.flightrecorder.internal.parser.binary.TypedArrayParser;
import com.jrockit.mc.flightrecorder.internal.parser.model.ProducerDescriptor;

public class ChunkMetadata {
    private final ProducerDescriptor[] producers;
    private final long startTimeNanos;
    private final long endTimeNanos;
    private final long startTicks;
    private final double ticsPerNano;
    private final int previousCheckPoint;
    private static final TypedArrayParser<ProducerDescriptor> PRODUCERS_PARSER = new TypedArrayParser<ProducerDescriptor>(new ProducerParser());

    public ChunkMetadata(byte[] data, int metaDataOffset) throws InvalidFlrFileException {
        Offset offset = new Offset(data, metaDataOffset);
        offset.increase(4);
        this.producers = PRODUCERS_PARSER.read(data, offset);
        this.startTimeNanos = LongParser.readLong(data, offset) * 1000L * 1000L;
        this.endTimeNanos = LongParser.readLong(data, offset) * 1000L * 1000L;
        this.startTicks = LongParser.readLong(data, offset);
        this.ticsPerNano = (double)LongParser.readLong(data, offset) / 1.0E9;
        this.previousCheckPoint = (int)LongParser.readLong(data, offset);
    }

    public ProducerDescriptor[] getProducers() {
        return this.producers;
    }

    public long getStartTimeNanos() {
        return this.startTimeNanos;
    }

    public long getEndTimeNanos() {
        return this.endTimeNanos;
    }

    public long getStartTicks() {
        return this.startTicks;
    }

    public double getTicsPerNano() {
        return this.ticsPerNano;
    }

    public int getPreviousCheckPoint() {
        return this.previousCheckPoint;
    }

    public long asNanoTimestame(long relativeTicks) {
        return this.startTimeNanos + (long)((double)(relativeTicks - this.startTicks) / this.ticsPerNano);
    }
}

