/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.common.unit;

import com.jrockit.mc.common.unit.IScalarAffineTransform;
import com.jrockit.mc.common.unit.IUnit;
import com.jrockit.mc.common.unit.LinearKindOfQuantity;
import com.jrockit.mc.common.unit.LinearQuantity;
import com.jrockit.mc.common.unit.QuantityConversionException;
import com.jrockit.mc.common.unit.ScaleFactor;
import java.text.NumberFormat;
import java.util.Collections;
import java.util.Map;

public class LinearUnit
implements IUnit<LinearQuantity>,
Comparable<LinearUnit> {
    private final LinearKindOfQuantity kindOfQuantity;
    private final ScaleFactor factorToAtom;
    private final String unitId;
    private final String unitSymbol;
    private final String nonBreakingSuffix;
    private final String breakingSuffix;
    private final String unitDescription;
    private final String[] altNames;
    private final Map<String, ? extends LinearUnit> parseMap;

    public LinearUnit(LinearKindOfQuantity kindOfQuantity, String unitId, ScaleFactor factorToAtom, String unitSymbol, String unitDesc, String ... altNames) {
        this.kindOfQuantity = kindOfQuantity;
        this.unitId = unitId;
        this.unitSymbol = unitSymbol;
        this.nonBreakingSuffix = unitSymbol.length() == 0 ? "" : "\u00a0" + unitSymbol;
        this.breakingSuffix = this.nonBreakingSuffix.replace('\u00a0', ' ');
        this.unitDescription = unitDesc;
        this.factorToAtom = factorToAtom;
        this.altNames = altNames != null ? altNames : EMPTY_STRING_ARRAY;
        this.parseMap = Collections.singletonMap(unitSymbol.replace('\u00a0', ' '), this);
    }

    public LinearKindOfQuantity getContentType() {
        return this.kindOfQuantity;
    }

    @Override
    public String getAppendableSuffix(boolean useBreakingSpace) {
        return useBreakingSpace ? this.breakingSuffix : this.nonBreakingSuffix;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof LinearUnit) {
            LinearUnit otherUnit = (LinearUnit)other;
            return this.kindOfQuantity.equals(otherUnit.kindOfQuantity) && this.factorToAtom.equals(otherUnit.factorToAtom);
        }
        return false;
    }

    public int hashCode() {
        return this.kindOfQuantity.hashCode() << 16 + this.factorToAtom.hashCode();
    }

    @Override
    public int compareTo(LinearUnit other) {
        return this.factorToAtom.compareTo(other.factorToAtom);
    }

    @Override
    public LinearQuantity quantity(Number value) {
        if (value instanceof Long || value instanceof Integer || value instanceof Short || value instanceof Byte) {
            return this.quantity(value.longValue());
        }
        return this.quantity(value.doubleValue());
    }

    @Override
    public LinearQuantity quantity(long numericalValue) {
        return new LinearQuantity.LongStored(numericalValue, this);
    }

    @Override
    public LinearQuantity quantity(double numericalValue) {
        return new LinearQuantity.DoubleStored(numericalValue, this);
    }

    @Override
    public IScalarAffineTransform valueTransformTo(IUnit<LinearQuantity> targetUnit) {
        if (targetUnit.getContentType() != this.getContentType()) {
            throw new IllegalArgumentException("Cannot convert from unit " + this + " into unit of type " + targetUnit.getContentType().getIdentifier());
        }
        return this.factorToAtom.chainWithInverse(((LinearUnit)targetUnit).valueFactorToAtom());
    }

    public ScaleFactor valueFactorTo(LinearUnit targetUnit) {
        if (targetUnit.getContentType() != this.getContentType()) {
            throw new IllegalArgumentException("Cannot convert from unit " + this + " into unit of type " + targetUnit.getContentType().getIdentifier());
        }
        return this.factorToAtom.chainWithInverse(targetUnit.valueFactorToAtom());
    }

    private ScaleFactor valueFactorToAtom() {
        return this.factorToAtom;
    }

    public String toString() {
        return String.valueOf(this.getIdentifier()) + '[' + this.getLocalizedSymbol() + ']';
    }

    @Override
    public String getIdentifier() {
        return this.unitId;
    }

    @Override
    public String getLocalizedSymbol() {
        return this.unitSymbol;
    }

    @Override
    public String getLocalizedDescription() {
        return this.unitDescription;
    }

    @Override
    public String[] getAltLocalizedNames() {
        return this.altNames;
    }

    protected boolean isCustom() {
        return false;
    }

    public LinearQuantity asWellKnownQuantity() {
        return this.quantity(1L);
    }

    protected String persistableStringFor(Number numericalValue) {
        return String.valueOf(String.valueOf(numericalValue)) + ' ' + this.unitId;
    }

    protected String localizedFormatFor(Number numericalValue, boolean useBreakingSpace, boolean allowCustomUnit) {
        NumberFormat formatter = LinearKindOfQuantity.getNumberFormat(useBreakingSpace);
        return String.valueOf(formatter.format(numericalValue)) + this.getAppendableSuffix(useBreakingSpace);
    }

    public LinearQuantity customParseInteractive(String interactiveQuantity) throws QuantityConversionException {
        return this.kindOfQuantity.parseInteractive(interactiveQuantity, this.parseMap);
    }

    protected static class Custom
    extends LinearUnit {
        private final ScaleFactor factorToDefinition;
        private final LinearUnit definitionUnit;

        protected Custom(LinearKindOfQuantity kindOfQuantity, String unitId, ScaleFactor factorToDefinition, LinearUnit definitionUnit, String unitSymbol, String unitDesc, String ... altNames) {
            super(kindOfQuantity, unitId, definitionUnit.factorToAtom.chain(factorToDefinition), unitSymbol, unitDesc, altNames);
            this.factorToDefinition = factorToDefinition;
            this.definitionUnit = definitionUnit;
        }

        @Override
        protected boolean isCustom() {
            return true;
        }

        @Override
        public LinearQuantity asWellKnownQuantity() {
            if (this.factorToDefinition.isInteger()) {
                return this.definitionUnit.quantity(this.factorToDefinition.targetValue(1L));
            }
            return this.definitionUnit.quantity(this.factorToDefinition.targetValue(1.0));
        }

        @Override
        protected String persistableStringFor(Number numericalValue) {
            if (numericalValue instanceof Long && this.factorToDefinition.isInteger() && !this.factorToDefinition.targetOutOfRange(numericalValue.longValue(), Long.MAX_VALUE)) {
                return this.definitionUnit.persistableStringFor(this.factorToDefinition.targetValue(numericalValue.longValue()));
            }
            return this.definitionUnit.persistableStringFor(this.factorToDefinition.targetValue(numericalValue.doubleValue()));
        }

        @Override
        protected String localizedFormatFor(Number numericalValue, boolean useBreakingSpace, boolean allowCustomUnit) {
            if (allowCustomUnit) {
                return super.localizedFormatFor(numericalValue, useBreakingSpace, allowCustomUnit);
            }
            if (numericalValue instanceof Long && this.factorToDefinition.isInteger() && !this.factorToDefinition.targetOutOfRange(numericalValue.longValue(), Long.MAX_VALUE)) {
                return this.definitionUnit.localizedFormatFor(this.factorToDefinition.targetValue(numericalValue.longValue()), useBreakingSpace, false);
            }
            return this.definitionUnit.localizedFormatFor(this.factorToDefinition.targetValue(numericalValue.doubleValue()), useBreakingSpace, false);
        }

        @Override
        public boolean equals(Object other) {
            return super.equals(other);
        }

        @Override
        public int hashCode() {
            return super.hashCode();
        }
    }
}

