/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.ui.components.fields;

import com.jrockit.mc.common.IMCMethod;
import com.jrockit.mc.common.IMCStackTrace;
import com.jrockit.mc.common.IMCThread;
import com.jrockit.mc.common.IMCType;
import com.jrockit.mc.common.unit.UnitLookup;
import com.jrockit.mc.flightrecorder.spi.IEventType;
import com.jrockit.mc.flightrecorder.spi.IProducer;
import com.jrockit.mc.flightrecorder.ui.common.Constants;
import com.jrockit.mc.flightrecorder.ui.components.fields.EventTypeField;
import com.jrockit.mc.flightrecorder.ui.components.fields.ProducerField;
import com.jrockit.mc.ui.model.fields.ByteField;
import com.jrockit.mc.ui.model.fields.ClassField;
import com.jrockit.mc.ui.model.fields.Field;
import com.jrockit.mc.ui.model.fields.HexField;
import com.jrockit.mc.ui.model.fields.MethodField;
import com.jrockit.mc.ui.model.fields.NanosTimeSpanField;
import com.jrockit.mc.ui.model.fields.NanosTimeStampField;
import com.jrockit.mc.ui.model.fields.NumberField;
import com.jrockit.mc.ui.model.fields.PercentageField;
import com.jrockit.mc.ui.model.fields.StringField;
import com.jrockit.mc.ui.model.fields.ThreadField;

public class ContentTypeField
extends Field {
    private static final Field MEMORY_FIELD = new ByteField(0);
    private static final Field TIMESPAN_FIELD = new NanosTimeSpanField(0);
    private static final Field TIMESTAMP_FIELD = new NanosTimeStampField(0);
    private static final Field STRING_FIELD = new StringField(0);
    private static final Field NUMBER_FIELD = new NumberField(0);
    private static final Field EVENT_TYPE_FIELD = new EventTypeField(0);
    private static final Field PRODUCER_FIELD = new ProducerField(0);
    private static final Field THREAD_FIELD = new ThreadField(0);
    private static final Field CLASS_FIELD = new ClassField(0);
    private static final Field METHOD_FIELD = new MethodField(0);
    private static final Field HEX_FIELD = new HexField(0);
    private static final Field PERCENTAGE_FIELD = new PercentageField(0);
    private String m_contentTypeString;

    public ContentTypeField(int id) {
        super(id);
    }

    public void setContentTypeString(String contentTypeString) {
        this.m_contentTypeString = contentTypeString;
    }

    public String formatObject(Object value) {
        if (value instanceof IMCStackTrace) {
            return "stacktrace";
        }
        return this.getField(value, this.m_contentTypeString).formatForClipboard(value);
    }

    public Field getField(Object value, String contentTypeString) {
        if (value instanceof IMCThread) {
            return THREAD_FIELD;
        }
        if (value instanceof IMCType) {
            return CLASS_FIELD;
        }
        if (value instanceof IMCMethod) {
            return METHOD_FIELD;
        }
        if (value instanceof IEventType) {
            return EVENT_TYPE_FIELD;
        }
        if (value instanceof IProducer) {
            return PRODUCER_FIELD;
        }
        if (Constants.CONTENT_TYPE_MEMORY.equals(contentTypeString)) {
            return MEMORY_FIELD;
        }
        if (Constants.CONTENT_TYPE_TIMESPAN.equals(contentTypeString)) {
            return TIMESPAN_FIELD;
        }
        if (Constants.CONTENT_TYPE_TIME_STAMP.equals(contentTypeString)) {
            return TIMESTAMP_FIELD;
        }
        if (Constants.CONTENT_TYPE_PLAINT_TEXT.equals(contentTypeString)) {
            return STRING_FIELD;
        }
        if (Constants.CONTENT_TYPE_PERCENTAGE.equals(contentTypeString)) {
            return PERCENTAGE_FIELD;
        }
        if (UnitLookup.ADDRESS.getIdentifier().equals(contentTypeString)) {
            return HEX_FIELD;
        }
        if (value instanceof Number) {
            return NUMBER_FIELD;
        }
        return STRING_FIELD;
    }

    public static String formatObject(Object value, String contentTypeString) {
        if (value instanceof IMCThread) {
            return THREAD_FIELD.formatObject(value);
        }
        if (value instanceof IMCType) {
            return CLASS_FIELD.formatObject(value);
        }
        if (value instanceof IMCMethod) {
            return METHOD_FIELD.formatObject(value);
        }
        if (value instanceof IEventType) {
            return EVENT_TYPE_FIELD.formatObject(value);
        }
        if (value instanceof IProducer) {
            return PRODUCER_FIELD.formatObject(value);
        }
        if (value instanceof IMCStackTrace) {
            return "stacktrace";
        }
        if (Constants.CONTENT_TYPE_MEMORY.equals(contentTypeString)) {
            return MEMORY_FIELD.formatObject(value);
        }
        if (Constants.CONTENT_TYPE_TIMESPAN.equals(contentTypeString)) {
            return TIMESPAN_FIELD.formatObject(value);
        }
        if (Constants.CONTENT_TYPE_TIME_STAMP.equals(contentTypeString)) {
            return TIMESTAMP_FIELD.formatObject(value);
        }
        if (Constants.CONTENT_TYPE_PLAINT_TEXT.equals(contentTypeString)) {
            return STRING_FIELD.formatObject(value);
        }
        if (Constants.CONTENT_TYPE_PERCENTAGE.equals(contentTypeString)) {
            return PERCENTAGE_FIELD.formatObject(value);
        }
        if (UnitLookup.ADDRESS.getIdentifier().equals(contentTypeString)) {
            return HEX_FIELD.formatObject(value);
        }
        if (value instanceof Number) {
            return NUMBER_FIELD.formatObject(value);
        }
        return ContentTypeField.defaultFormat((Object)value);
    }

    public int compare(Object a, Object b, boolean order) {
        Field bField;
        Field aField = this.getField(a, this.m_contentTypeString);
        if (aField == (bField = this.getField(b, this.m_contentTypeString))) {
            return aField.compare(a, b, order);
        }
        if (order) {
            return this.formatObject(a).compareTo(this.formatObject(b));
        }
        return this.formatObject(b).compareTo(this.formatObject(a));
    }
}

