/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.ui.components.graph;

import com.jrockit.mc.common.persistence.ISettingFetcher;
import com.jrockit.mc.common.persistence.PersistenceToolkit;
import com.jrockit.mc.common.persistence.Setting;
import com.jrockit.mc.common.persistence.Type;
import com.jrockit.mc.flightrecorder.ui.components.graph.GraphHelper;
import com.jrockit.mc.flightrecorder.ui.components.graph.TooltipVerbosity;
import com.jrockit.mc.flightrecorder.ui.components.graph.renderer.coloring.EventColorType;
import com.jrockit.mc.flightrecorder.ui.components.selection.EventTypeDescriptor;
import com.jrockit.mc.flightrecorder.ui.components.selection.EventTypeDescriptorRepository;
import com.jrockit.mc.ui.fields.FieldToolkit;
import com.jrockit.mc.ui.misc.MCColor;
import com.jrockit.mc.ui.model.fields.Field;
import com.jrockit.mc.ui.model.fields.NanosTimeSpanField;
import java.awt.Color;
import java.util.List;

public class ChartConfiguration {
    static final String NAME = "chartConfiguration";
    static final String TOOLTIP_VERBOSITY = "tooltipVerbosity";
    static final String ALLOW_OPERATIVE_SEY = "allowOperativeSet";
    static final String ALLOW_TRANSITIONS = "allowTransitions";
    static final String SHOW_TRANSITIONS = "showTransitions";
    static final String ALLOW_BACKDROP = "allowBckdrop";
    static final String SHOW_BACKDROP = "showBackdrop";
    static final String EVENT_TYPES = "eventTypes";
    static final String TRACKS = "tracks";
    static final String ALLOW_FILTERING = "allowFiltering";
    static final String GRADIENT_END_VALUE = "gradientBeginValue";
    static final String GRADIENT_BEGIN_VALUE = "gradientEndValue";
    static final String GRADIENT_END_COLOR = "gradientEndColor";
    static final String GRADIENT_BEGIN_COLOR = "gradientBeginColor";
    static final String COLORING_ATTRIBUTE = "coloringAttribute";
    static final String EVENT_COLOR_TYPE = "eventColorType";
    public static final String ROOT_TRACK_GROUP = "rootTrackGroup";
    public static final Field FIELD_TIME = new NanosTimeSpanField(0);
    private static Field[] FIELD_PROTOTYPES = new Field[]{FIELD_TIME};
    private final Field[] m_fields;
    private final Setting m_setting = new Setting("chartConfiguration");

    static {
        PersistenceToolkit.registerFetcher(ChartConfiguration.class, (ISettingFetcher)new ISettingFetcher<ChartConfiguration>(){

            public Setting getSetting(ChartConfiguration chartConfiguration) {
                return chartConfiguration.m_setting;
            }
        });
    }

    public ChartConfiguration() {
        this.m_fields = FieldToolkit.instantiateFieldArray((Field[])FIELD_PROTOTYPES);
        this.setGradientBeginColor(new MCColor(Color.YELLOW));
        this.setGradientBeginValue(0.0);
        this.setGradientEndColor(new MCColor(Color.BLUE));
        this.setGradientEndValue(1.0);
        this.setEventColorType(EventColorType.EVENT_TYPE_COLOR);
        this.setAttribute("(eventType)");
    }

    public Color getEdgeColor() {
        return Color.BLACK;
    }

    public Color getThreadBackgroundColor(int index) {
        return index % 2 == 0 ? GraphHelper.EVEN_COLOR.getAWTColor() : GraphHelper.ODD_COLOR.getAWTColor();
    }

    public void setGCBackdropVisible(boolean showBackdrop) {
        this.m_setting.setChildObject(SHOW_BACKDROP, (Object)showBackdrop);
    }

    public boolean isGCBackdropVisible() {
        return (Boolean)this.m_setting.getChildObject(SHOW_BACKDROP, Boolean.class);
    }

    public TooltipVerbosity getTooltipVerbosity() {
        return TooltipVerbosity.lookup((String)this.m_setting.getChildObject(TOOLTIP_VERBOSITY, String.class));
    }

    public void setTooltipVerbosity(TooltipVerbosity verbosity) {
        this.m_setting.setChildObject(TOOLTIP_VERBOSITY, (Object)verbosity.getKey());
    }

    public Field getTimeFormatField() {
        return this.m_fields[0];
    }

    public void setShowTransitions(boolean show) {
        this.m_setting.setChildObject(SHOW_TRANSITIONS, (Object)show);
    }

    public boolean getShowTransition() {
        return (Boolean)this.m_setting.getChildObject(SHOW_TRANSITIONS, Boolean.class);
    }

    public EventTypeDescriptorRepository getEventTypes() {
        return (EventTypeDescriptorRepository)this.m_setting.getChildObject(EVENT_TYPES, EventTypeDescriptorRepository.class);
    }

    public List<EventTypeDescriptor> getTracks() {
        return (List)this.m_setting.getChildObject(TRACKS, new Type(List.class, new Type[]{new Type(EventTypeDescriptor.class)}));
    }

    public boolean getAllowTransitions() {
        return (Boolean)this.m_setting.getChildObject(ALLOW_TRANSITIONS, Boolean.class);
    }

    public boolean getAllowBackdrop() {
        return (Boolean)this.m_setting.getChildObject(ALLOW_BACKDROP, Boolean.class);
    }

    public boolean getAllowOperativeSet() {
        return (Boolean)this.m_setting.getChildObject(ALLOW_OPERATIVE_SEY, Boolean.class);
    }

    public boolean getAllowFiltering() {
        return (Boolean)this.m_setting.getChildObject(ALLOW_FILTERING, Boolean.class);
    }

    public double getGradientEndValue() {
        return (Double)this.m_setting.getChildObject(GRADIENT_END_VALUE, Double.class);
    }

    public double getGradientBeginValue() {
        return (Double)this.m_setting.getChildObject(GRADIENT_BEGIN_VALUE, Double.class);
    }

    public MCColor getGradientEndColor() {
        return (MCColor)this.m_setting.getChildObject(GRADIENT_END_COLOR, MCColor.class);
    }

    public MCColor getGradientBeginColor() {
        return (MCColor)this.m_setting.getChildObject(GRADIENT_BEGIN_COLOR, MCColor.class);
    }

    public void setGradientEndValue(double value) {
        this.m_setting.setChildObject(GRADIENT_END_VALUE, (Object)value);
    }

    public void setGradientBeginValue(double value) {
        this.m_setting.setChildObject(GRADIENT_BEGIN_VALUE, (Object)value);
    }

    public void setGradientEndColor(MCColor color) {
        this.m_setting.setChildObject(GRADIENT_END_COLOR, (Object)color);
    }

    public void setGradientBeginColor(MCColor color) {
        this.m_setting.setChildObject(GRADIENT_BEGIN_COLOR, (Object)color);
    }

    public void setEventColorType(EventColorType eventTypeColor) {
        this.m_setting.setChildObject(EVENT_COLOR_TYPE, (Object)eventTypeColor.getIdentifier());
    }

    public EventColorType getEventColorType() {
        return EventColorType.lookup((String)this.m_setting.getChildObject(EVENT_COLOR_TYPE, String.class));
    }

    public String getAttribute() {
        return (String)this.m_setting.getChildObject("attributeIdentifier", String.class);
    }

    private void setAttribute(String attribute) {
        this.m_setting.setChildObject("attributeIdentifier", (Object)attribute);
    }

    public String getRoot() {
        return (String)this.m_setting.getChildObject(ROOT_TRACK_GROUP, String.class);
    }
}

