/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.ui.components.histogram;

import com.jrockit.mc.common.persistence.ISettingFetcher;
import com.jrockit.mc.common.persistence.PersistenceToolkit;
import com.jrockit.mc.common.persistence.Setting;
import com.jrockit.mc.components.ui.util.ImageDescriptor;
import com.jrockit.mc.flightrecorder.ui.components.column.ColumnDescriptor;
import com.jrockit.mc.flightrecorder.ui.components.column.ColumnDescriptorRepository;
import com.jrockit.mc.flightrecorder.ui.messages.internal.Messages;

public final class HistogramColumnDescriptorRepository
extends ColumnDescriptorRepository {
    private static final int DEFAULT_MAX_BUCKET_COUNT = 100000;
    static final String GROUP_BY_COLUMN = "groupByColumn";
    public static final String SHOW_PIE_CHART = "showPieChart";
    public static final String SHOW_TABLE = "showTable";
    public static final String PIE_CHART_POSITION = "pieChartPosition";
    public static final String MAXIMUM_BUCKET_COUNT = "maximumBucketCount";
    public static final String GROUP_BY = "groupBy";
    public static final String USER_SELCTABLE_GROUP = "userSelectableGroupBy";

    static {
        PersistenceToolkit.registerFetcher(HistogramColumnDescriptorRepository.class, (ISettingFetcher)new ISettingFetcher<HistogramColumnDescriptorRepository>(){

            public Setting getSetting(HistogramColumnDescriptorRepository columnDescriptorRepository) {
                return columnDescriptorRepository.getSetting();
            }
        });
    }

    public HistogramColumnDescriptorRepository() {
        this.setShowTable(true);
        this.setShowPieChart(false);
        this.setPieChartPosition("west");
        this.setMaximumCount(100000);
        this.getGroupColumn().setName(Messages.HISTOGRAM_COMPONENT_GROUP_BY_COLUMN_NAME_TEXT);
    }

    public String getGroupByAttribute() {
        return (String)PersistenceToolkit.getSetting((Object)this.getGroupColumn()).getChildObject(GROUP_BY, String.class);
    }

    public void setGroupByAttribute(String groupBy) {
        PersistenceToolkit.getSetting((Object)this.getGroupColumn()).setChildObject(GROUP_BY, (Object)groupBy);
    }

    public boolean getUserSelectableGroupBy() {
        return (Boolean)PersistenceToolkit.getSetting((Object)this.getGroupColumn()).getChildObject(USER_SELCTABLE_GROUP, Boolean.class);
    }

    public void setUserSelectableGroupBy(String userSelectable) {
        PersistenceToolkit.getSetting((Object)this.getGroupColumn()).setChildObject(USER_SELCTABLE_GROUP, (Object)userSelectable);
    }

    public void setPieChartPosition(String orientation) {
        this.getSetting().setChildObject(PIE_CHART_POSITION, (Object)orientation);
    }

    public void setShowPieChart(boolean visible) {
        this.getSetting().setChildObject(SHOW_PIE_CHART, (Object)visible);
    }

    public boolean getShowPieChart() {
        return (Boolean)this.getSetting().getChildObject(SHOW_PIE_CHART, Boolean.class);
    }

    public String getPieChartPosition() {
        return (String)this.getSetting().getChildObject(PIE_CHART_POSITION, String.class);
    }

    public void setShowTable(boolean visible) {
        this.getSetting().setChildObject(SHOW_TABLE, (Object)visible);
    }

    public boolean getShowTable() {
        return (Boolean)this.getSetting().getChildObject(SHOW_TABLE, Boolean.class);
    }

    public int getMaximumCount() {
        return (Integer)this.getSetting().getChildObject(MAXIMUM_BUCKET_COUNT, Integer.class);
    }

    public void setMaximumCount(int maximumCount) {
        this.getSetting().setChildObject(MAXIMUM_BUCKET_COUNT, (Object)maximumCount);
    }

    public ColumnDescriptor getGroupColumn() {
        return (ColumnDescriptor)this.getSetting().getChildObject(GROUP_BY_COLUMN, ColumnDescriptor.class);
    }

    @Override
    public boolean hasImage() {
        return this.getSetting().hasChild("icon");
    }

    @Override
    public ImageDescriptor getImageDescriptor() {
        return (ImageDescriptor)this.getSetting().getChildObject("icon", ImageDescriptor.class);
    }
}

