/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.ui.components.histogram;

import com.jrockit.mc.common.util.ColorToolkit;
import com.jrockit.mc.flightrecorder.spi.IEventType;
import com.jrockit.mc.flightrecorder.spi.IProducer;
import com.jrockit.mc.flightrecorder.ui.components.histogram.HistogramItem;
import com.jrockit.mc.ui.fields.CommonLabelProvider;
import com.jrockit.mc.ui.misc.SWTColorToolkit;
import java.awt.Color;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;

public class HistogramLabelProvider
extends LabelProvider
implements IColorProvider {
    private final boolean m_useColorIcons;

    HistogramLabelProvider(boolean useColorIcons) {
        this.m_useColorIcons = useColorIcons;
    }

    public Image getImage(Object element) {
        if (element instanceof HistogramItem) {
            if (this.m_useColorIcons) {
                return SWTColorToolkit.getColorThumbnail((RGB)HistogramLabelProvider.getRGBForItem((HistogramItem)element));
            }
            return CommonLabelProvider.getStandardImage((Object)((HistogramItem)element).getKey());
        }
        return null;
    }

    public String getText(Object element) {
        return null;
    }

    public org.eclipse.swt.graphics.Color getForeground(Object element) {
        return null;
    }

    public org.eclipse.swt.graphics.Color getBackground(Object element) {
        if (element instanceof HistogramItem) {
            return SWTColorToolkit.getColor((RGB)HistogramLabelProvider.getRGBForItem((HistogramItem)element));
        }
        return null;
    }

    private static RGB getRGBForItem(HistogramItem item) {
        return SWTColorToolkit.asRGB((Color)HistogramLabelProvider.getColorForItem(item));
    }

    private static Color getColorForItem(HistogramItem item) {
        if (item.isOther()) {
            return Color.LIGHT_GRAY;
        }
        if (item.getKey() instanceof IEventType) {
            return ((IEventType)item.getKey()).getColor();
        }
        if (item.getKey() instanceof IProducer) {
            return ((IProducer)item.getKey()).getColor();
        }
        return ColorToolkit.getDistinguishableColor((Object)item.getKey());
    }
}

