/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.greychart.ui.views.configuration;

import com.jrockit.mc.components.ui.services.IServiceLocator;
import com.jrockit.mc.components.ui.settings.BooleanInput;
import com.jrockit.mc.components.ui.settings.ColorInput;
import com.jrockit.mc.components.ui.settings.ComboInput;
import com.jrockit.mc.components.ui.settings.IInput;
import com.jrockit.mc.components.ui.settings.ListInput;
import com.jrockit.mc.components.ui.settings.LocalizedStringInput;
import com.jrockit.mc.greychart.ui.messages.internal.Messages;
import com.jrockit.mc.greychart.ui.model.ChartDescriptor;
import com.jrockit.mc.greychart.ui.model.DataSeriesDescriptor;
import com.jrockit.mc.greychart.ui.model.Style;
import com.jrockit.mc.greychart.ui.model.YAxisDescriptor;
import com.jrockit.mc.greychart.ui.views.DataSeriesLabelProvider;
import com.jrockit.mc.greychart.ui.views.configuration.DataSeriesProvider;
import com.jrockit.mc.ui.fields.FieldLabelProvider;
import com.jrockit.mc.ui.fields.FieldTableViewer;
import com.jrockit.mc.ui.model.fields.Field;
import java.util.List;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Table;

public abstract class DataSeriesInput
extends ListInput<DataSeriesDescriptor> {
    private static final String DATA_SERIES_STYLE = "style";
    private static final Field[] FIELD_PROTYPES = new Field[]{DataSeriesProvider.FIELD_NAME, DataSeriesProvider.FIELD_DESCRIPTION};
    private final YAxisDescriptor m_yAxiDescriptor;
    private final ChartDescriptor m_chartDescriptor;
    private final IServiceLocator m_serviceLocator;

    protected abstract List<IInput> createDataSourceInputs(IServiceLocator var1);

    protected DataSeriesInput(IServiceLocator sl, ChartDescriptor chartDescriptor, YAxisDescriptor axiDescriptor, String name) {
        super(name);
        this.m_serviceLocator = sl;
        this.m_yAxiDescriptor = axiDescriptor;
        this.m_chartDescriptor = chartDescriptor;
        this.addInputs(sl);
    }

    public final IServiceLocator getServiceLocator() {
        return this.m_serviceLocator;
    }

    protected void addInputs(IServiceLocator sl) {
        this.addInput((IInput)this.createName());
        this.addInput((IInput)this.createDescription());
        this.addInputs(this.createDataSourceInputs(sl));
        this.addInput((IInput)this.createShowInLegend());
        this.addInput((IInput)this.createStacked());
        this.addInput((IInput)this.createDrawLine());
        this.addInput((IInput)this.createFill());
        this.addInput(this.createDataSeriesStyle());
        this.addInput((IInput)this.createLineColor());
        this.addInput((IInput)this.createTopFillColor());
        this.addInput((IInput)this.createBottomFillColor());
    }

    protected ColorInput createBottomFillColor() {
        return new ColorInput("bottomColor", Messages.CHART_COMPONENT_CONFIGURATION_DATA_SERIES_FILL_BOTTOM_COLOR_INPUT_TEXT);
    }

    protected ColorInput createTopFillColor() {
        return new ColorInput("topColor", Messages.CHART_COMPONENT_CONFIGURATION_DATA_SERIES_FILL_COLOR_INPUT_TEXT);
    }

    protected ColorInput createLineColor() {
        return new ColorInput("lineColor", Messages.CHART_COMPONENT_CONFIGURATION_DATA_SERIES_LINE_COLOR_INPUT_TEXT);
    }

    protected BooleanInput createFill() {
        return new BooleanInput("filled", Messages.CHART_COMPONENT_CONFIGURATION_DATA_SERIES_FILL_INPUT_TEXT);
    }

    protected BooleanInput createDrawLine() {
        return new BooleanInput("drawLine", Messages.CHART_COMPONENT_CONFIGURATION_DATA_SERIES_DRAW_LINE_INPUT_TEXT);
    }

    protected BooleanInput createStacked() {
        return new BooleanInput("stack", Messages.CHART_COMPONENT_CONFIGURATION_DATA_SERIES_STACK_INPUT_TEXT);
    }

    protected BooleanInput createShowInLegend() {
        return new BooleanInput("showInLegend", Messages.CHART_COMPONENT_CONFIGURATION_DATA_SERIES_SHOW_LEGEND_INPUT_TEXT);
    }

    private LocalizedStringInput createDescription() {
        return new LocalizedStringInput("description", Messages.CHART_COMPONENT_CONFIGURATION_DATA_SERIES_DESCRIPTION_INPUT_TEXT);
    }

    protected LocalizedStringInput createName() {
        return new LocalizedStringInput("name", Messages.CHART_COMPONENT_CONFIGURATION_DATA_SERIES_NAME_INPUT_TEXT);
    }

    protected List<DataSeriesDescriptor> createDetailList() {
        return this.m_yAxiDescriptor.getDataSeries();
    }

    protected IInput createDataSeriesStyle() {
        return new ComboInput(DATA_SERIES_STYLE, Messages.CHART_COMPONENT_CONFIGURATION_DATA_SERIES_STYLE_INPUT_TEXT, Style.createNameKeyMap());
    }

    protected StructuredViewer createTableViewer(Composite parent) {
        Table table = new Table(parent, 268503812);
        FieldTableViewer tableViewer = new FieldTableViewer(table, FIELD_PROTYPES);
        tableViewer.setContentProvider((IContentProvider)new DataSeriesProvider());
        tableViewer.setLabelProvider((IBaseLabelProvider)new FieldLabelProvider(FIELD_PROTYPES, (IBaseLabelProvider)new DataSeriesLabelProvider(this.m_chartDescriptor, parent.getDisplay(), 12)));
        tableViewer.setInput(this.m_yAxiDescriptor.getDataSeries());
        return tableViewer;
    }

    protected IInput createTopInput() {
        return null;
    }
}

