/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.ui.model.fields.filtering;

import com.jrockit.mc.common.parsing.Token;
import com.jrockit.mc.common.parsing.Tokenizer;
import com.jrockit.mc.ui.model.fields.Field;
import com.jrockit.mc.ui.model.fields.filtering.And;
import com.jrockit.mc.ui.model.fields.filtering.BooleanValue;
import com.jrockit.mc.ui.model.fields.filtering.Equal;
import com.jrockit.mc.ui.model.fields.filtering.IExpression;
import com.jrockit.mc.ui.model.fields.filtering.Invert;
import com.jrockit.mc.ui.model.fields.filtering.Less;
import com.jrockit.mc.ui.model.fields.filtering.Messages;
import com.jrockit.mc.ui.model.fields.filtering.More;
import com.jrockit.mc.ui.model.fields.filtering.Or;
import com.jrockit.mc.ui.model.fields.filtering.Regexp;
import com.jrockit.mc.ui.model.fields.filtering.Wildcard;
import java.text.ParseException;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.eclipse.osgi.util.NLS;

public final class ExpressionFactory {
    public static IExpression createExpressionForField(Field field, String expression) throws ParseException {
        Tokenizer tokenizer;
        if (field != null && expression != null && (tokenizer = new Tokenizer(expression)).hasNext()) {
            return ExpressionFactory.parseTokens(field, tokenizer);
        }
        return new BooleanValue(true);
    }

    private static IExpression parseTokens(Field field, Tokenizer tokenizer) throws ParseException {
        if (ExpressionFactory.isExpression(tokenizer.peek().text)) {
            return ExpressionFactory.parseAllTokens(tokenizer, field);
        }
        try {
            return new Or(ExpressionFactory.parseAllTokens(new Tokenizer("== " + tokenizer.getText()), field), new Wildcard(field, tokenizer.getText()));
        }
        catch (ParseException pe) {
            return new Wildcard(field, tokenizer.getText());
        }
    }

    private static IExpression parseAllTokens(Tokenizer tokenizer, Field field) throws ParseException {
        IExpression e = ExpressionFactory.parse(tokenizer, field);
        if (tokenizer.hasNext()) {
            throw new ParseException(NLS.bind((String)Messages.EXPRESSION_FACTORY_UNABLE_TO_READ_X, (Object)tokenizer.peek().text), tokenizer.peek().start);
        }
        return e;
    }

    private static boolean isExpression(String text) {
        return ExpressionFactory.isLeftParenthesis(text) || ExpressionFactory.isLess(text) || ExpressionFactory.isLessEqual(text) || ExpressionFactory.isEqual(text) || ExpressionFactory.isMore(text) || ExpressionFactory.isNotEqual(text) || ExpressionFactory.isMoreEqual(text) || ExpressionFactory.isRegexp(text);
    }

    private static IExpression parse(Tokenizer tokenizer, Field field) throws ParseException {
        if (tokenizer.hasNext()) {
            IExpression exp;
            String tokenText = tokenizer.peek().text;
            IExpression iExpression = exp = ExpressionFactory.isLeftParenthesis(tokenText) ? ExpressionFactory.createExpressionInParanthesis(tokenizer, field) : ExpressionFactory.createExpression(tokenizer, field);
            if (tokenizer.hasNext()) {
                tokenText = tokenizer.peek().text;
                if (ExpressionFactory.isAndOperator(tokenText)) {
                    tokenizer.next();
                    return new And(exp, ExpressionFactory.parse(tokenizer, field));
                }
                if (ExpressionFactory.isOrOperator(tokenText)) {
                    tokenizer.next();
                    return new Or(exp, ExpressionFactory.parse(tokenizer, field));
                }
            }
            return exp;
        }
        throw new ParseException(Messages.EXPRESSION_FACTORY_EXPRESSION_NOT_COMPLETE, 0);
    }

    private static IExpression createExpressionInParanthesis(Tokenizer tokenizer, Field field) throws ParseException {
        tokenizer.next();
        IExpression expression = ExpressionFactory.parse(tokenizer, field);
        if (!tokenizer.hasNext() || !ExpressionFactory.isRightParenthesis(tokenizer)) {
            throw new ParseException(Messages.EXPRESSION_FACTORY_MISSING_LEFT_PARANTHESIS, 1);
        }
        tokenizer.next();
        return expression;
    }

    private static IExpression createExpression(Tokenizer tokenizer, Field field) throws ParseException {
        String expressionText = tokenizer.peek().text;
        if (ExpressionFactory.isRegexp(expressionText)) {
            return ExpressionFactory.createRegexp(tokenizer);
        }
        if (ExpressionFactory.isLess(expressionText)) {
            return new Less(field, ExpressionFactory.readFieldValue(tokenizer, field));
        }
        if (ExpressionFactory.isMore(expressionText)) {
            return new More(field, ExpressionFactory.readFieldValue(tokenizer, field));
        }
        if (ExpressionFactory.isEqual(expressionText)) {
            return new Equal(field, ExpressionFactory.readFieldValue(tokenizer, field));
        }
        if (ExpressionFactory.isMoreEqual(expressionText)) {
            Object value = ExpressionFactory.readFieldValue(tokenizer, field);
            return new Or(new More(field, value), new Equal(field, value));
        }
        if (ExpressionFactory.isLessEqual(expressionText)) {
            Object value = ExpressionFactory.readFieldValue(tokenizer, field);
            return new Or(new Less(field, value), new Equal(field, value));
        }
        if (ExpressionFactory.isNotEqual(expressionText)) {
            Object value = ExpressionFactory.readFieldValue(tokenizer, field);
            return new Invert(new Equal(field, value));
        }
        throw new ParseException(NLS.bind((String)Messages.EXPRESSION_FACTORY_UNKNOWN_OPERATOR_X, (Object)expressionText), tokenizer.peek().start);
    }

    private static IExpression createRegexp(Tokenizer tokenizer) throws ParseException {
        tokenizer.next();
        if (tokenizer.hasNext()) {
            Token token = tokenizer.next();
            try {
                return new Regexp(Pattern.compile(token.text));
            }
            catch (PatternSyntaxException pse) {
                throw new ParseException(Messages.ExpressionFactory_NOT_A_VALID_REGULAR_EXPRESSION, token.start);
            }
        }
        throw new ParseException(Messages.EXPRESSION_FACTORY_MISSING_REGULAR_EXPRESSION, 0);
    }

    private static Object readFieldValue(Tokenizer tokenizer, Field field) throws ParseException {
        tokenizer.next();
        if (tokenizer.hasNext()) {
            Object object = field.parse(tokenizer);
            if (object == null) {
                throw new ParseException(Messages.EXPRESSION_FACTORY_COULD_NOT_READ_VALUE, 0);
            }
            return object;
        }
        throw new ParseException(Messages.EXPRESSION_FACTORY_MISSING_VALUE_AFTER_OPERATOR, 0);
    }

    private static boolean isLeftParenthesis(String tokenText) {
        return tokenText.equals("(");
    }

    private static boolean isRightParenthesis(Tokenizer tokenizer) {
        return tokenizer.peek().text.equals(")");
    }

    private static boolean isOrOperator(String tokenText) {
        return tokenText.equals("||") || tokenText.equalsIgnoreCase("or");
    }

    private static boolean isAndOperator(String tokenText) {
        return tokenText.equals("&&") || tokenText.equalsIgnoreCase("and");
    }

    private static boolean isNotEqual(String text) {
        return "<>".equals(text) || "!=".equals(text);
    }

    private static boolean isLessEqual(String text) {
        return "<=".equals(text);
    }

    private static boolean isMoreEqual(String text) {
        return ">=".equals(text);
    }

    private static boolean isLess(String text) {
        return "<".equals(text);
    }

    private static boolean isMore(String text) {
        return ">".equals(text);
    }

    private static boolean isEqual(String text) {
        return "==".equals(text) || "=".equals(text) || "equal".equalsIgnoreCase(text) || "equals".equalsIgnoreCase(text);
    }

    private static boolean isRegexp(String text) {
        return "regexp:".equalsIgnoreCase(text);
    }
}

