/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.components.ui.contributions;

import com.jrockit.mc.common.io.IOToolkit;
import com.jrockit.mc.common.persistence.PersistenceToolkit;
import com.jrockit.mc.common.persistence.Translations;
import com.jrockit.mc.components.ui.ComponentsPlugin;
import com.jrockit.mc.components.ui.contributions.SettingsFileToolkit;
import com.jrockit.mc.components.ui.contributions.UserInterfaceContribution;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;

final class UserInterfaceContributionFactory {
    private static final String PROPERTIES_EXTENSION = ".properties";
    private static final String USERINTEFACE_EXTENSION_POINT_ID = "com.jrockit.mc.components.ui.userInterface";
    private static final String USER_INTERFACE_FILENAME = "userInterfaceFile";
    private static final String CONTAINER_IDENTIFIER = "containerIdentifier";

    UserInterfaceContributionFactory() {
    }

    public static List<UserInterfaceContribution> createFromExtensions() {
        ArrayList<UserInterfaceContribution> containers = new ArrayList<UserInterfaceContribution>();
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint exPoint = registry.getExtensionPoint(USERINTEFACE_EXTENSION_POINT_ID);
        if (exPoint != null) {
            IExtension[] iExtensionArray = exPoint.getExtensions();
            int n = iExtensionArray.length;
            int n2 = 0;
            while (n2 < n) {
                IExtension extension = iExtensionArray[n2];
                IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
                int n3 = iConfigurationElementArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement element = iConfigurationElementArray[n4];
                    UserInterfaceContribution uic = UserInterfaceContributionFactory.createContribution(element, extension.getNamespaceIdentifier());
                    if (uic != null) {
                        containers.add(uic);
                    }
                    ++n4;
                }
                ++n2;
            }
        }
        return containers;
    }

    private static UserInterfaceContribution createContribution(IConfigurationElement element, String id) {
        block6: {
            InputStream in;
            block5: {
                UserInterfaceContribution userInterfaceContribution;
                in = null;
                try {
                    in = UserInterfaceContributionFactory.openResourceInputStream(element, UserInterfaceContributionFactory.extractFileName(element));
                    if (in == null) break block5;
                    UserInterfaceContribution ui = (UserInterfaceContribution)PersistenceToolkit.createObjectFromInputStream(UserInterfaceContribution.class, (InputStream)in);
                    if (ui != null) {
                        Bundle bundle = Platform.getBundle((String)id);
                        Object nameObject = bundle.getHeaders().get("Bundle-Name");
                        String name = nameObject instanceof String ? (String)nameObject : "Unknown";
                        UserInterfaceContributionFactory.addLocalizationProperties(element, ui);
                        ui.getContributionDescriptor().setContainerIdentifier(UserInterfaceContributionFactory.extractContainer(element));
                        ui.getContributionDescriptor().setName(name);
                        ui.getContributionDescriptor().setIdentifier(bundle.getSymbolicName());
                    }
                    userInterfaceContribution = ui;
                }
                catch (Exception e) {
                    try {
                        ComponentsPlugin.getDefault().getLogger().log(Level.SEVERE, "Error loading user interface contribution", e);
                    }
                    catch (Throwable throwable) {
                        IOToolkit.closeSilently(in);
                        throw throwable;
                    }
                    IOToolkit.closeSilently((Closeable)in);
                    break block6;
                }
                IOToolkit.closeSilently((Closeable)in);
                return userInterfaceContribution;
            }
            IOToolkit.closeSilently((Closeable)in);
        }
        return null;
    }

    private static void addLocalizationProperties(IConfigurationElement element, UserInterfaceContribution ui) throws IOException {
        String fileBaseName = UserInterfaceContributionFactory.removeXMLExtension(UserInterfaceContributionFactory.extractFileName(element));
        if (fileBaseName != null) {
            String[] stringArray = Translations.getVariants();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String locale = stringArray[n2];
                InputStream is = null;
                try {
                    is = UserInterfaceContributionFactory.openResourceInputStream(element, UserInterfaceContributionFactory.createLocalizedPropertiesFilename(fileBaseName, locale));
                    if (is != null) {
                        Properties p = new Properties();
                        p.load(is);
                        Translations.getGlobal().addProperties(locale, p);
                    }
                }
                catch (Throwable throwable) {
                    IOToolkit.closeSilently(is);
                    throw throwable;
                }
                IOToolkit.closeSilently((Closeable)is);
                ++n2;
            }
        } else {
            ComponentsPlugin.getDefault().getLogger().log(Level.SEVERE, "User contribution file must end with .xml to be able to find localization properties");
        }
    }

    private static String removeXMLExtension(String extractFileName) {
        int index = extractFileName.toUpperCase().lastIndexOf(".XML");
        if (index != -1) {
            return extractFileName.substring(0, index);
        }
        return null;
    }

    private static String createLocalizedPropertiesFilename(String fileName, String locale) {
        if (locale.length() == 0) {
            return String.valueOf(fileName) + PROPERTIES_EXTENSION;
        }
        return String.valueOf(fileName) + '_' + locale + PROPERTIES_EXTENSION;
    }

    private static String extractFileName(IConfigurationElement element) {
        return element.getAttribute(USER_INTERFACE_FILENAME);
    }

    private static String extractContainer(IConfigurationElement element) {
        return element.getAttribute(CONTAINER_IDENTIFIER);
    }

    private static InputStream openResourceInputStream(IConfigurationElement element, String fileName) throws IOException {
        if (fileName != null) {
            String bundleId = element.getContributor().getName();
            Bundle bundle = Platform.getBundle((String)bundleId);
            try {
                return FileLocator.openStream((Bundle)bundle, (IPath)new Path(fileName), (boolean)false);
            }
            catch (IOException io) {
                return null;
            }
        }
        return null;
    }

    public static UserInterfaceContribution createFromUserSettings(String id) throws IOException {
        File userSettingsFile = SettingsFileToolkit.getUserSettingsFile(id);
        if (userSettingsFile.exists()) {
            try {
                return (UserInterfaceContribution)PersistenceToolkit.createObjectFromFile(UserInterfaceContribution.class, (File)userSettingsFile);
            }
            catch (Exception e) {
                ComponentsPlugin.getDefault().getLogger().log(Level.WARNING, "Error loading user settings for " + id + ". Will try with backup", e);
            }
        }
        if ((userSettingsFile = SettingsFileToolkit.getBackupUserSettingsFile(id)).exists()) {
            try {
                return (UserInterfaceContribution)PersistenceToolkit.createObjectFromFile(UserInterfaceContribution.class, (File)userSettingsFile);
            }
            catch (Exception e) {
                ComponentsPlugin.getDefault().getLogger().log(Level.WARNING, "Error loading backup user settings at " + userSettingsFile + ". Will reset to default.", e);
            }
        }
        UserInterfaceContribution contribution = new UserInterfaceContribution();
        contribution.getContributionDescriptor().setContainerIdentifier(id);
        return contribution;
    }
}

