/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.components.ui.design.view.layout;

import com.jrockit.mc.components.ui.design.designelement.IDesignElement;
import com.jrockit.mc.components.ui.design.menus.DesignMenu;
import com.jrockit.mc.components.ui.design.view.layout.DesignElementLabelProvider;
import com.jrockit.mc.components.ui.design.view.layout.DesignElementProvider;
import com.jrockit.mc.components.ui.design.view.layout.LayoutSubPart;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.events.MenuDetectEvent;
import org.eclipse.swt.events.MenuDetectListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IWorkbenchSite;

public final class TreePart
extends LayoutSubPart {
    private TreeViewer m_viewer;

    public TreePart(IWorkbenchSite site) {
        super(site);
    }

    @Override
    protected void updateControl() {
        try {
            this.m_viewer.getControl().setRedraw(false);
            this.m_viewer.setInput((Object)this.getDesignerTab());
            this.m_viewer.refresh();
            this.updateSelection();
        }
        finally {
            this.m_viewer.getControl().setRedraw(true);
        }
    }

    private void updateSelection() {
        StructuredSelection ss;
        StructuredSelection structuredSelection = ss = this.getDesignElement() != null ? new StructuredSelection((Object)this.getDesignElement()) : new StructuredSelection();
        if (!this.m_viewer.getSelection().equals(ss)) {
            this.m_viewer.setSelection((ISelection)ss);
        }
    }

    @Override
    protected void enableControl() {
        this.m_viewer.getControl().setEnabled(true);
    }

    @Override
    protected void disableControl() {
        this.m_viewer.setInput(null);
        this.m_viewer.getControl().setEnabled(false);
    }

    private void select(IStructuredSelection ss) {
        if (!ss.isEmpty()) {
            ((IDesignElement)ss.getFirstElement()).setSelected();
            this.getSite().getSelectionProvider().setSelection((ISelection)ss);
        }
    }

    private void showMenu(Control control) {
        IDesignElement element = this.getSelectedElement();
        if (element != null) {
            DesignMenu.show(control, element, this.getServiceLocator());
        }
    }

    private IDesignElement getSelectedElement() {
        return (IDesignElement)((IStructuredSelection)this.m_viewer.getSelection()).getFirstElement();
    }

    @Override
    protected Control createPart(Composite parent) {
        this.m_viewer = new TreeViewer(parent);
        this.m_viewer.setContentProvider((IContentProvider)new DesignElementProvider());
        this.m_viewer.setLabelProvider((IBaseLabelProvider)new DesignElementLabelProvider());
        this.m_viewer.setAutoExpandLevel(1000);
        this.m_viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                TreePart.this.select((IStructuredSelection)event.getSelection());
            }
        });
        this.m_viewer.getControl().addMenuDetectListener(new MenuDetectListener(){

            public void menuDetected(MenuDetectEvent e) {
                TreePart.this.showMenu(TreePart.this.m_viewer.getControl());
            }
        });
        return this.m_viewer.getControl();
    }
}

