/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.components.ui.design.view.layout;

import com.jrockit.mc.components.ui.design.LayoutItem;
import com.jrockit.mc.components.ui.design.LayoutItemType;
import com.jrockit.mc.components.ui.design.SupportedControl;
import com.jrockit.mc.components.ui.design.designelement.IDesignElement;
import com.jrockit.mc.components.ui.design.view.layout.LayoutSubPart;
import com.jrockit.mc.components.ui.design.view.layout.MaximumListener;
import com.jrockit.mc.components.ui.design.view.layout.MinimumListener;
import com.jrockit.mc.components.ui.design.view.layout.SliderControl;
import com.jrockit.mc.components.ui.design.view.layout.WeightListener;
import com.jrockit.mc.components.ui.messages.internal.Messages;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbenchSite;

public final class TypePart
extends LayoutSubPart {
    private Composite m_container;
    private SliderControl m_maxSizeControl;
    private SliderControl m_minSizeControl;
    private SliderControl m_weightControl;
    private final Map<Control, SupportedControl> m_layoutDataTocontrolSupportBinding = new HashMap<Control, SupportedControl>();

    public TypePart(IWorkbenchSite site) {
        super(site);
    }

    @Override
    protected void updateControl() {
        IDesignElement element = this.getDesignElement();
        if (element != null) {
            LayoutItem active = element.getLayoutItem();
            this.m_maxSizeControl.setValue(this.getSizeValue(active.getLayoutData().getMaximumSize()));
            this.m_minSizeControl.setValue(this.getSizeValue(active.getLayoutData().getMinimumSize()));
            this.m_weightControl.setValue(this.getWeightValue(active.getLayoutData().getWeight()));
        }
    }

    @Override
    protected void enableControl() {
        LayoutItemType type = this.getParentType();
        if (type != null) {
            this.updateControlEnablement(type);
        }
    }

    @Override
    protected void disableControl() {
        this.m_maxSizeControl.setEnabled(false);
        this.m_minSizeControl.setEnabled(false);
        this.m_weightControl.setEnabled(false);
    }

    private void updateControlEnablement(LayoutItemType type) {
        for (Map.Entry<Control, SupportedControl> entry : this.m_layoutDataTocontrolSupportBinding.entrySet()) {
            entry.getKey().setEnabled(type.supportsControl(entry.getValue()));
        }
    }

    private void bindSupportControlToLayoutData(SupportedControl sc, Control control) {
        this.m_layoutDataTocontrolSupportBinding.put(control, sc);
    }

    @Override
    protected Control createPart(Composite parent) {
        this.m_container = new Composite(parent, 0);
        this.m_container.setLayout((Layout)new GridLayout(1, false));
        GridData gd3 = new GridData(4, 4, true, false);
        this.m_weightControl = this.createWeightControl(this.m_container);
        this.m_weightControl.setLayoutData(gd3);
        this.bindSupportControlToLayoutData(SupportedControl.WEIGHT, (Control)this.m_weightControl);
        GridData gd1 = new GridData(4, 4, true, false);
        this.m_minSizeControl = this.createMinControl(this.m_container);
        this.m_minSizeControl.setLayoutData(gd1);
        this.bindSupportControlToLayoutData(SupportedControl.MIN_SIZE, (Control)this.m_minSizeControl);
        GridData gd2 = new GridData(4, 4, true, false);
        this.m_maxSizeControl = this.createMaxControl(this.m_container);
        this.m_maxSizeControl.setLayoutData(gd2);
        this.bindSupportControlToLayoutData(SupportedControl.MAX_SIZE, (Control)this.m_maxSizeControl);
        return this.m_container;
    }

    private SliderControl createWeightControl(Composite container) {
        SliderControl control = new SliderControl(container);
        control.addChangeListener(new WeightListener(this));
        control.setText(Messages.TYPE_PART_WEIGHT_SLIDER_TEXT);
        control.setValues(this.createWeightValues());
        return control;
    }

    private double[] createWeightValues() {
        double[] values = new double[10];
        int n = 0;
        while (n < values.length) {
            values[n] = 1 + n;
            ++n;
        }
        return values;
    }

    private LayoutItemType getParentType() {
        IDesignElement ci;
        IDesignElement el = this.getDesignElement();
        if (el != null && (ci = el.getParentElement()) != null) {
            return ci.getLayoutItem().getType();
        }
        return null;
    }

    private SliderControl createMaxControl(Composite container) {
        SliderControl control = new SliderControl(container);
        control.addChangeListener(new MaximumListener(this));
        control.setText("Maximum:");
        control.setValues(this.createSizeValues(true));
        return control;
    }

    double[] createSizeValues(boolean allowInfinity) {
        double[] values = new double[101];
        int index = 0;
        values[index++] = Double.NEGATIVE_INFINITY;
        int n = 0;
        while (n <= 200) {
            values[index++] = n;
            n += 5;
        }
        n = 210;
        while (n <= 500) {
            values[index++] = n;
            n += 10;
        }
        n = 520;
        while (n <= 800) {
            values[index++] = n;
            n += 20;
        }
        while (index < values.length) {
            values[index] = values[index - 1] + 50.0;
            ++index;
        }
        if (allowInfinity) {
            values[values.length - 1] = Double.POSITIVE_INFINITY;
        }
        return values;
    }

    private SliderControl createMinControl(Composite container) {
        SliderControl control = new SliderControl(container);
        control.addChangeListener(new MinimumListener(this));
        control.setText("Minimum:");
        control.setValues(this.createSizeValues(false));
        return control;
    }

    private double getWeightValue(float weight) {
        return weight == Float.MAX_VALUE ? Double.POSITIVE_INFINITY : (double)weight;
    }

    private double getSizeValue(int size) {
        if (size == Integer.MAX_VALUE) {
            return Double.POSITIVE_INFINITY;
        }
        if (size == Integer.MIN_VALUE) {
            return Double.NEGATIVE_INFINITY;
        }
        return size;
    }
}

