/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.components.ui.design.view.toolbar;

import com.jrockit.mc.components.ui.ComponentsPlugin;
import com.jrockit.mc.components.ui.messages.internal.Messages;
import com.jrockit.mc.components.ui.settings.IInput;
import com.jrockit.mc.components.ui.settings.IconInput;
import com.jrockit.mc.components.ui.settings.InputPanel;
import com.jrockit.mc.components.ui.settings.LocalizedStringInput;
import com.jrockit.mc.components.ui.settings.StringInput;
import com.jrockit.mc.components.ui.tab.BaseDescriptor;
import com.jrockit.mc.components.ui.tab.TabGroupDescriptor;
import com.jrockit.mc.components.ui.tab.TabItemDescriptor;
import com.jrockit.mc.ui.UIPlugin;
import com.jrockit.mc.ui.wizards.IPerformFinishable;
import java.util.ArrayList;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.widgets.Composite;

final class TabWizardPage
extends WizardPage
implements IPerformFinishable {
    private static final int LARGE_ICON_SIZE = 64;
    private static final int SMALL_ICON_SIZE = 16;
    private final BaseDescriptor m_tabBase;

    protected TabWizardPage(BaseDescriptor base) {
        super("tabPage");
        this.m_tabBase = base;
        this.setTabImageDescriptor(base);
    }

    private void setTabImageDescriptor(BaseDescriptor base) {
        if (base instanceof TabItemDescriptor) {
            this.setImageDescriptor(ComponentsPlugin.getDefault().getMCImageDescriptor("designLarge.gif"));
        } else {
            this.setImageDescriptor(ComponentsPlugin.getDefault().getMCImageDescriptor("defaultGroupLarge.png"));
        }
    }

    public void createControl(Composite parent) {
        InputPanel inputPanel = this.createInputPanel(parent);
        this.setControl(inputPanel.getControl());
        this.setTitle(this.getTitle());
        this.getShell().setImage(UIPlugin.getDefault().getImage("toolbar.gif"));
        this.updateComplete();
    }

    private InputPanel createInputPanel(Composite parent) {
        ArrayList<IInput> inputs = new ArrayList<IInput>();
        inputs.add(new StringInput("identifier", Messages.TAB_WIZARD_IDENTIFIER_INPUT_TEXT));
        inputs.add(new StringInput("placementPath", Messages.TAB_WIZARD_PLACEMENT_PATH_TEXT));
        inputs.add(new LocalizedStringInput("name", Messages.TAB_WIZARD_NAME_INPUT_TEXT));
        inputs.add(new LocalizedStringInput("description", Messages.TAB_WIZARD_DESCRIPTION_INPUT_TEXT));
        inputs.add(this.createIcon("icon", Messages.TAB_WIZARD_SMALL_ICON_INPUT_TEXT, 16));
        if (this.m_tabBase instanceof TabGroupDescriptor) {
            inputs.add(this.createIcon("iconLarge", Messages.TAB_WIZARD_LARGE_ICON_INPUT_TEXT, 64));
        }
        return new InputPanel(parent, this.m_tabBase, inputs);
    }

    private IInput createIcon(String property, String name, int size) {
        IconInput ii = new IconInput(property, name);
        ii.setSize(size);
        return ii;
    }

    private void updateComplete() {
        this.setPageComplete(this.m_tabBase.getName().length() > 0 && this.m_tabBase.getIdentifier().length() > 0);
    }

    public boolean performFinish() {
        return true;
    }
}

