/*
 * Decompiled with CFR 0.152.
 */
package com.sixthhosp.gcmpa.configs;

import com.sixthhosp.gcmpa.xmlbeans.tasks.TasksDocument;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import org.apache.commons.io.FileUtils;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Platform;
import org.eclipse.osgi.service.datalocation.Location;

public class ConfigFile {
    private static String softFolderPath;
    private static String projectFolderPath;
    private static String userFolderPath;
    private static String dataFolderPath;
    private static String taskResultsFolderPath;
    private static String taskInfoFolderPath;
    private static String tmpFolderPath;
    private static String taskInfoXmlPath;
    private static String lockFilePath;
    private static String locFolderPath;
    private static String toolConfXmlPath;

    public static String getSoftFolderPath() {
        if (softFolderPath == null) {
            String path;
            Location location = Platform.getInstallLocation();
            URL url = location.getURL();
            softFolderPath = path = url.getPath();
        }
        return new File(softFolderPath).getAbsolutePath();
    }

    public static String getProjectFolderPath() {
        if (projectFolderPath == null) {
            try {
                projectFolderPath = FileLocator.toFileURL((URL)Platform.getBundle((String)"com.sixthhosp.gcmpa").getEntry("")).getPath();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return projectFolderPath;
    }

    public static String getUserFolderPath() {
        if (userFolderPath == null) {
            userFolderPath = System.getProperty("user.home");
        }
        return userFolderPath;
    }

    public static String getDataFolderPath() {
        if (dataFolderPath == null) {
            dataFolderPath = String.valueOf(ConfigFile.getUserFolderPath()) + "/.ip4m";
        }
        return dataFolderPath;
    }

    public static String getTaskResultsFolderPath() {
        if (taskResultsFolderPath == null) {
            taskResultsFolderPath = String.valueOf(ConfigFile.getUserFolderPath()) + "/IP4M_Outputs";
        }
        return taskResultsFolderPath;
    }

    public static String getTaskInfoFolderPath() {
        if (taskInfoFolderPath == null) {
            taskInfoFolderPath = String.valueOf(ConfigFile.getDataFolderPath()) + "/task_infos";
        }
        return taskInfoFolderPath;
    }

    public static String getTmpFolderPath() {
        if (tmpFolderPath == null) {
            tmpFolderPath = String.valueOf(ConfigFile.getDataFolderPath()) + "/tmp";
        }
        return tmpFolderPath;
    }

    public static String getTaskInfoXmlPath() {
        if (taskInfoXmlPath == null) {
            taskInfoXmlPath = String.valueOf(ConfigFile.getTaskInfoFolderPath()) + "/task_infos.xml";
        }
        return taskInfoXmlPath;
    }

    public static String getLockFilePath() {
        if (lockFilePath == null) {
            lockFilePath = String.valueOf(ConfigFile.getDataFolderPath()) + "/ip4m.lck";
        }
        return lockFilePath;
    }

    public static String getLocFolderPath() {
        if (locFolderPath == null) {
            locFolderPath = String.valueOf(ConfigFile.getSoftFolderPath()) + "/loc";
        }
        return locFolderPath;
    }

    public static String getToolConfXmlPath() {
        if (toolConfXmlPath == null) {
            toolConfXmlPath = String.valueOf(ConfigFile.getSoftFolderPath()) + "/configs/tool_conf.xml";
        }
        return toolConfXmlPath;
    }

    public static void initial() {
        String[] dirList = new String[]{ConfigFile.getDataFolderPath(), ConfigFile.getTaskResultsFolderPath(), ConfigFile.getTaskInfoFolderPath(), ConfigFile.getTmpFolderPath()};
        int i = 0;
        while (i < dirList.length) {
            File dir = new File(dirList[i]);
            if (dir.isAbsolute() && !dir.isDirectory() && !dir.exists()) {
                try {
                    FileUtils.forceMkdir((File)dir);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            ++i;
        }
        File tasksInfoFile = new File(ConfigFile.getTaskInfoXmlPath());
        if (!tasksInfoFile.exists()) {
            try {
                TasksDocument tasksDocument = TasksDocument.Factory.newInstance();
                tasksDocument.addNewTasks();
                tasksDocument.save(tasksInfoFile);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

