/*
 * Decompiled with CFR 0.152.
 */
package com.sixthhosp.gcmpa.data;

import com.sixthhosp.gcmpa.configs.ConfigFile;
import com.sixthhosp.gcmpa.tasks.TaskBox;
import com.sixthhosp.gcmpa.tools.ToolBox;
import com.sixthhosp.gcmpa.xmlbeans.tasks.TasksDocument;
import com.sixthhosp.gcmpa.xmlbeans.tasks.TasksType;
import com.sixthhosp.gcmpa.xmlbeans.toolconf.ToolboxDocument;
import java.io.File;
import java.io.IOException;
import org.apache.xmlbeans.XmlException;

public class DataFactory {
    private static ToolBox toolBox;
    private static TaskBox taskBox;

    public static ToolBox getToolBox() {
        if (toolBox == null) {
            try {
                ToolboxDocument toolboxDocument = ToolboxDocument.Factory.parse((File)new File(ConfigFile.getToolConfXmlPath()));
                toolBox = new ToolBox(toolboxDocument);
            }
            catch (XmlException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return toolBox;
    }

    public static TaskBox getTaskBox() {
        if (taskBox == null) {
            try {
                TasksDocument tasksDocument = TasksDocument.Factory.parse((File)new File(ConfigFile.getTaskInfoXmlPath()));
                taskBox = new TaskBox(tasksDocument.getTasks());
            }
            catch (XmlException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return taskBox;
    }

    public static synchronized void saveTaskBox() {
        if (taskBox != null) {
            try {
                TasksDocument tasksDocument = TasksDocument.Factory.newInstance();
                TasksType tasksType = taskBox.saveASTasksType();
                tasksDocument.setTasks(tasksType);
                tasksDocument.save(new File(ConfigFile.getTaskInfoXmlPath()));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

