/*
 * Decompiled with CFR 0.152.
 */
package com.sixthhosp.gcmpa.editors;

import com.sixthhosp.gcmpa.configs.ConfigFile;
import com.sixthhosp.gcmpa.editors.ei.HtmlEditorInput;
import java.io.File;
import java.net.MalformedURLException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.EditorPart;

public class HtmlEditor
extends EditorPart {
    public static final String ID = "com.sixthhosp.gcmpa.editors.htmleditor";
    private String outputPath;
    private Image image;
    private Browser browser;

    public void doSave(IProgressMonitor monitor) {
    }

    public void doSaveAs() {
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        if (input instanceof HtmlEditorInput) {
            HtmlEditorInput htmlEditorInput = (HtmlEditorInput)input;
            this.setSite((IWorkbenchPartSite)site);
            this.setInput(htmlEditorInput);
            this.setPartName(input.getName());
            String path = String.valueOf(ConfigFile.getProjectFolderPath()) + "/icons/editors/element.gif";
            this.image = new Image((Device)Display.getCurrent(), path);
            this.setTitleImage(this.image);
            this.outputPath = htmlEditorInput.getXmlTask().getHtmloutpath();
        }
    }

    public boolean isDirty() {
        return false;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void createPartControl(Composite parent) {
        try {
            parent.setLayout((Layout)new FillLayout());
            Composite composite = new Composite(parent, 0);
            composite.setBackground(composite.getDisplay().getSystemColor(1));
            composite.setLayoutData((Object)new GridData(768));
            GridLayout gridLayout = new GridLayout(1, false);
            gridLayout.marginHeight = 0;
            gridLayout.marginWidth = 0;
            composite.setLayout((Layout)gridLayout);
            final Image refImage = new Image((Device)composite.getDisplay(), String.valueOf(ConfigFile.getProjectFolderPath()) + "/" + "icons/browser/arrow_rotate_clockwise.png");
            final Image backImage = new Image((Device)composite.getDisplay(), String.valueOf(ConfigFile.getProjectFolderPath()) + "/" + "icons/browser/arrow_left.png");
            final Image forImage = new Image((Device)composite.getDisplay(), String.valueOf(ConfigFile.getProjectFolderPath()) + "/" + "icons/browser/arrow_right.png");
            ToolBar toolBar = new ToolBar(composite, 0x800000);
            GridData gridData = new GridData();
            gridData.horizontalIndent = 5;
            toolBar.setLayoutData((Object)gridData);
            ToolItem refreshItem = new ToolItem(toolBar, 8);
            refreshItem.setImage(refImage);
            refreshItem.setToolTipText("Refresh Page");
            refreshItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    HtmlEditor.this.browser.refresh();
                }
            });
            ToolItem backItem = new ToolItem(toolBar, 8);
            backItem.setImage(backImage);
            backItem.setToolTipText("Backward");
            backItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    HtmlEditor.this.browser.back();
                }
            });
            ToolItem forwardItem = new ToolItem(toolBar, 8);
            forwardItem.setImage(forImage);
            forwardItem.setToolTipText("Forward");
            forwardItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    HtmlEditor.this.browser.forward();
                }
            });
            toolBar.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    refImage.dispose();
                    backImage.dispose();
                    forImage.dispose();
                }
            });
            Label sepLabel = new Label(composite, 258);
            sepLabel.setLayoutData((Object)new GridData(768));
            File outputFile = new File(this.outputPath);
            String url = outputFile.toURI().toURL().toString();
            this.browser = new Browser(composite, 0);
            this.browser.setLayoutData((Object)new GridData(1808));
            this.browser.setUrl(url);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
    }

    public void setFocus() {
        this.browser.setFocus();
    }

    public void dispose() {
        super.dispose();
        this.image.dispose();
    }
}

