/*
 * Decompiled with CFR 0.152.
 */
package com.sixthhosp.gcmpa.editors;

import com.sixthhosp.gcmpa.configs.ConfigFile;
import com.sixthhosp.gcmpa.editors.ei.LogEditorInput;
import com.sixthhosp.gcmpa.views.tasktree.actions.OpenFileUtils;
import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.EditorPart;

public class LogEditor
extends EditorPart {
    public static final String ID = "com.sixthhosp.gcmpa.editors.logditor";
    private String cmdString;
    private String stderrString;
    private String stdoutString;
    private Image image;
    private Composite composite;
    private Button button;
    private String resultsFolderPath;

    public void doSave(IProgressMonitor monitor) {
    }

    public void doSaveAs() {
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        if (input instanceof LogEditorInput) {
            LogEditorInput logEditorInput = (LogEditorInput)input;
            this.setSite((IWorkbenchPartSite)site);
            this.setInput(logEditorInput);
            this.setPartName(input.getName());
            String path = String.valueOf(ConfigFile.getProjectFolderPath()) + "/icons/editors/logs.gif";
            this.image = new Image((Device)Display.getCurrent(), path);
            this.setTitleImage(this.image);
            this.cmdString = logEditorInput.getXmlTask().getCommandline();
            try {
                this.stdoutString = FileUtils.readFileToString((File)new File(logEditorInput.getXmlTask().getStdoutpath()));
                this.stderrString = FileUtils.readFileToString((File)new File(logEditorInput.getXmlTask().getStderrpath()));
            }
            catch (IOException e) {
                e.printStackTrace();
                this.stderrString = "";
                this.stdoutString = "";
            }
            this.resultsFolderPath = logEditorInput.getXmlTask().getOutputsfolderpath();
        }
    }

    public boolean isDirty() {
        return false;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void createPartControl(Composite parent) {
        FontData[] fontDatas;
        parent.setLayout((Layout)new FillLayout());
        ScrolledComposite sc = new ScrolledComposite(parent, 768);
        sc.setExpandHorizontal(true);
        sc.setExpandVertical(true);
        ScrollBar vBar = sc.getVerticalBar();
        vBar.setIncrement(15);
        FontData[] fontDataArray = fontDatas = Display.getCurrent().getSystemFont().getFontData();
        int n = fontDatas.length;
        int n2 = 0;
        while (n2 < n) {
            FontData fontData = fontDataArray[n2];
            fontData.setStyle(1);
            ++n2;
        }
        final Font font = new Font((Device)Display.getCurrent(), fontDatas);
        Color whiteColor = Display.getCurrent().getSystemColor(1);
        this.composite = new Composite((Composite)sc, 0);
        sc.setContent((Control)this.composite);
        this.composite.setBackground(whiteColor);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginLeft = 5;
        gridLayout.marginTop = 10;
        this.composite.setLayout((Layout)gridLayout);
        Label cmdLabel = new Label(this.composite, 16384);
        cmdLabel.setText("Task Command Line:");
        cmdLabel.setFont(font);
        cmdLabel.setBackground(whiteColor);
        Text cmdText = new Text(this.composite, 2632);
        GC gc = new GC((Drawable)cmdText);
        FontMetrics fontMetrics = gc.getFontMetrics();
        int h = fontMetrics.getHeight();
        int w = fontMetrics.getAverageCharWidth();
        gc.dispose();
        cmdText.setBackground(whiteColor);
        cmdText.setText(this.cmdString);
        GridData cmdTextGridData = new GridData();
        cmdTextGridData.heightHint = h * 4;
        cmdTextGridData.widthHint = w * 150;
        cmdText.setLayoutData((Object)cmdTextGridData);
        GridData boxGridData = new GridData();
        boxGridData.heightHint = h * 10;
        boxGridData.widthHint = w * 150;
        new Label(this.composite, 258).setLayoutData((Object)new GridData(768));
        Label stdoutLabel = new Label(this.composite, 16384);
        stdoutLabel.setText("Task Standard Output:");
        stdoutLabel.setFont(font);
        stdoutLabel.setBackground(whiteColor);
        Text stdoutText = new Text(this.composite, 2632);
        stdoutText.setBackground(whiteColor);
        stdoutText.setText(this.stdoutString);
        stdoutText.setLayoutData((Object)boxGridData);
        new Label(this.composite, 258).setLayoutData((Object)new GridData(768));
        Label stderrLabel = new Label(this.composite, 16384);
        stderrLabel.setText("Task Standard Error Output:");
        stderrLabel.setFont(font);
        stderrLabel.setBackground(whiteColor);
        Text stderrText = new Text(this.composite, 2632);
        stderrText.setBackground(whiteColor);
        stderrText.setText(this.stderrString);
        stderrText.setLayoutData((Object)boxGridData);
        new Label(this.composite, 258).setLayoutData((Object)new GridData(768));
        this.button = new Button(this.composite, 0);
        this.button.setText("Click here to open the results folder");
        this.button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    OpenFileUtils.opneFile(new File(LogEditor.this.resultsFolderPath));
                }
                catch (Exception e1) {
                    MessageDialog.openError((Shell)LogEditor.this.button.getShell(), (String)"Error", (String)e1.getMessage());
                }
            }
        });
        this.composite.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                LogEditor.this.button.setFocus();
            }
        });
        cmdLabel.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                LogEditor.this.button.setFocus();
            }
        });
        stderrLabel.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                LogEditor.this.button.setFocus();
            }
        });
        stdoutLabel.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                LogEditor.this.button.setFocus();
            }
        });
        sc.setMinSize(this.composite.computeSize(-1, -1));
        this.composite.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                font.dispose();
            }
        });
    }

    public void setFocus() {
        this.button.setFocus();
    }

    public void dispose() {
        super.dispose();
        this.image.dispose();
    }
}

