/*
 * Decompiled with CFR 0.152.
 */
package com.sixthhosp.gcmpa.editors;

import com.sixthhosp.gcmpa.configs.ConfigFile;
import com.sixthhosp.gcmpa.data.DataFactory;
import com.sixthhosp.gcmpa.editors.ei.ParamEditorInput;
import com.sixthhosp.gcmpa.editors.paramui.ParamHeaderPart;
import com.sixthhosp.gcmpa.editors.paramui.SeparatorBar;
import com.sixthhosp.gcmpa.tasks.XmlTask;
import com.sixthhosp.gcmpa.tools.Tool;
import com.sixthhosp.gcmpa.tools.Utils;
import com.sixthhosp.gcmpa.tools.misc.CommandLine;
import com.sixthhosp.gcmpa.tools.misc.ConfigureFiles;
import com.sixthhosp.gcmpa.tools.parameters.HtmlToolOutput;
import com.sixthhosp.gcmpa.tools.parameters.ToolOutput;
import com.sixthhosp.gcmpa.views.tooltree.provider.ToolLabelProvider;
import com.sixthhosp.gcmpa.xmlbeans.tool.InputsType;
import com.sixthhosp.gcmpa.xmlbeans.tool.OutputsType;
import com.sixthhosp.gcmpa.xmlbeans.tool.ToolDocument;
import com.sixthhosp.gcmpa.xmlbeans.tool.ToolType;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import org.apache.commons.lang.StringUtils;
import org.apache.xmlbeans.XmlException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.EditorPart;

public class ParamEditor
extends EditorPart {
    public static final String ID = "com.sixthhosp.gcmpa.editors.parameditor";
    private Tool tool;
    private Image image;
    private ScrolledComposite sc;
    private Composite topComposite;
    private LinkedHashMap<String, Object> inputs;
    private String workingDirectoryPath = com.sixthhosp.gcmpa.configs.Utils.generateRandomToolWorkingDir();
    private File workingDirectoryFile = new File(this.workingDirectoryPath);
    private String outputDirectoryPath;
    private File outputDirectoryFile;
    private ConfigureFiles configureFiles;
    private CommandLine commandLine;
    private LinkedHashMap<String, ToolOutput> outputs;
    private HtmlToolOutput htmlToolOutput;
    private Button executeButton;
    private HashMap<String, Object> toolDataModel = new HashMap();
    private String executeCommand;
    private int[] time;

    public void doSave(IProgressMonitor monitor) {
    }

    public void doSaveAs() {
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        if (input instanceof ParamEditorInput) {
            ParamEditorInput paramEditorInput = (ParamEditorInput)input;
            this.setSite((IWorkbenchPartSite)site);
            this.setInput(paramEditorInput);
            this.setPartName(input.getName());
            this.tool = paramEditorInput.getTool();
            String path = this.tool.getIconPath();
            if (StringUtils.isBlank((String)path)) {
                path = ToolLabelProvider.getDefaultToolImagePath();
            }
            this.image = new Image((Device)Display.getCurrent(), path);
            this.setTitleImage(this.image);
            String xmlFilePath = this.tool.getFilePath();
            try {
                File toolXMLFile = new File(xmlFilePath);
                ToolDocument toolDocument = ToolDocument.Factory.parse((File)toolXMLFile);
                ToolType toolType = toolDocument.getTool();
                InputsType inputsType = toolType.getInputs();
                OutputsType outputsType = toolType.getOutputs();
                ToolType.Command command = toolType.getCommand();
                ToolType.Configfiles configfiles = toolType.getConfigfiles();
                this.inputs = Utils.parseInputsType(inputsType);
                this.outputs = Utils.parseOutputsType(outputsType);
                this.htmlToolOutput = Utils.getHtmlToolOutput(this.outputs);
                this.configureFiles = new ConfigureFiles(configfiles, this.workingDirectoryPath);
                this.commandLine = new CommandLine(command);
                Utils.registerAlwaysValidatingForInputs(this.inputs);
            }
            catch (XmlException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public boolean isDirty() {
        return false;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void createPartControl(Composite parent) {
        parent.setLayout((Layout)new FillLayout());
        this.sc = new ScrolledComposite(parent, 768);
        this.sc.setExpandHorizontal(true);
        this.sc.setExpandVertical(true);
        ScrollBar vBar = this.sc.getVerticalBar();
        vBar.setIncrement(15);
        this.topComposite = new Composite((Composite)this.sc, 0);
        this.sc.setContent((Control)this.topComposite);
        this.topComposite.setLayout((Layout)new GridLayout(1, false));
        this.topComposite.setBackground(this.topComposite.getDisplay().getSystemColor(1));
        this.creatHeaderPart();
        this.creatInputPart();
        this.creatSeparatorLine();
        this.creatButtons();
        this.topComposite.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                ParamEditor.this.topComposite.setFocus();
            }
        });
        this.sc.setMinSize(this.topComposite.computeSize(-1, -1));
    }

    private void creatButtons() {
        FontData[] fontDatas;
        this.executeButton = new Button(this.topComposite, 8);
        this.executeButton.setText("Execute");
        this.executeButton.setToolTipText("Execute the tool");
        FontData[] fontDataArray = fontDatas = this.executeButton.getFont().getFontData();
        int n = fontDatas.length;
        int n2 = 0;
        while (n2 < n) {
            FontData fontData = fontDataArray[n2];
            fontData.setHeight((int)((double)fontData.getHeight() * 1.3));
            fontData.setStyle(1);
            ++n2;
        }
        final Font font = new Font((Device)Display.getCurrent(), fontDatas);
        this.executeButton.setFont(font);
        this.executeButton.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                font.dispose();
            }
        });
        GridData executeGridData = new GridData();
        executeGridData.widthHint = 300;
        executeGridData.horizontalIndent = 5;
        executeGridData.verticalIndent = 5;
        this.executeButton.setLayoutData((Object)executeGridData);
        this.registerButtonEvent();
    }

    private void registerButtonEvent() {
        this.executeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean isInputsOK = ParamEditor.this.checkValidate();
                if (isInputsOK) {
                    if (MessageDialog.openQuestion((Shell)ParamEditor.this.executeButton.getShell(), (String)"Confirm", (String)"Do you want to run this tool?")) {
                        IWorkbenchPage workbenchPage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                        ParamEditor.this.time = com.sixthhosp.gcmpa.configs.Utils.getCurrentTime3();
                        String t = String.valueOf(ParamEditor.this.time[0]) + "." + ParamEditor.this.time[1] + "." + ParamEditor.this.time[2] + "_" + ParamEditor.this.time[3] + "." + ParamEditor.this.time[4] + "." + ParamEditor.this.time[5];
                        ParamEditor.this.outputDirectoryPath = String.valueOf(ConfigFile.getTaskResultsFolderPath()) + "/" + ParamEditor.this.tool.getName().replaceAll("\\s+", "_") + "_" + t;
                        ParamEditor.this.outputDirectoryFile = new File(ParamEditor.this.outputDirectoryPath);
                        ParamEditor.this.doSave();
                        workbenchPage.closeEditor((IEditorPart)ParamEditor.this, false);
                        ParamEditor.this.runToolTask();
                    }
                } else {
                    MessageDialog.openError((Shell)ParamEditor.this.executeButton.getShell(), (String)"Inputs Validation Error", (String)"Please Checking The Inputs!");
                }
            }
        });
    }

    protected void runToolTask() {
        this.storeToDataModel();
        this.createConfigFiles();
        this.createCommandLine();
        final XmlTask xmlTask = new XmlTask(this);
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                XmlTask.addJobsNum();
                DataFactory.getTaskBox().add(xmlTask);
                final TableViewer tableViewer = xmlTask.getTableViewer();
                tableViewer.getTable().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (tableViewer != null && !tableViewer.getTable().isDisposed()) {
                            tableViewer.refresh();
                            tableViewer.setSelection((ISelection)new StructuredSelection((Object)xmlTask), true);
                        }
                    }
                });
                xmlTask.start();
                DataFactory.saveTaskBox();
                XmlTask.minusJobsNum();
            }
        };
        Thread taskThread = new Thread(runnable);
        taskThread.start();
    }

    private void createCommandLine() {
        this.commandLine.velocityinterpolate(this.toolDataModel);
        this.executeCommand = this.commandLine.getExecuteCommandLine();
    }

    private void createConfigFiles() {
        this.configureFiles.generateConfigFiles(this.toolDataModel);
        this.configureFiles.updateDataModel(this.toolDataModel);
    }

    private void storeToDataModel() {
        HashMap<String, Object> inputsDataModel = Utils.getDataModelFromInputs(this.inputs);
        this.toolDataModel.putAll(inputsDataModel);
        HashMap<String, String> outputsDataModel = Utils.getDataModelFromOutputs(this.outputs);
        this.toolDataModel.putAll(outputsDataModel);
        this.toolDataModel.put("WORKDIR", this.workingDirectoryPath);
        this.toolDataModel.put("OUTDIR", this.outputDirectoryPath);
        this.toolDataModel.put("SOFTDIR", ConfigFile.getSoftFolderPath());
    }

    private void doSave() {
        Utils.doSaveForInputs(this.inputs);
        Utils.setOutDirectoryPathForOutputs(this.outputs, this.outputDirectoryPath);
        Utils.doSaveForOutputs(this.outputs);
    }

    private boolean checkValidate() {
        boolean b = true;
        if (!Utils.startValidatingForInputs(this.inputs)) {
            b = false;
        }
        return b;
    }

    private void creatSeparatorLine() {
        SeparatorBar bar = new SeparatorBar();
        bar.creatContents(this.topComposite);
    }

    private void creatInputPart() {
        Utils.creatInputsContents(this.inputs, this.topComposite, this.topComposite);
    }

    private void creatHeaderPart() {
        ParamHeaderPart headerPart = new ParamHeaderPart(this.tool);
        headerPart.creatContents(this.topComposite, this.topComposite);
    }

    public ToolType saveAsToolType() {
        ToolType toolType = ToolType.Factory.newInstance();
        toolType.setId(this.tool.getId());
        toolType.setName(this.tool.getName());
        toolType.setVersion(this.tool.getVersion());
        toolType.setDescription(this.tool.getDescription());
        toolType.setIconpath(this.tool.getIconPath());
        toolType.setHelppath(this.tool.getHelpPath());
        ToolType.Command command = this.commandLine.saveAsCommand();
        toolType.setCommand(command);
        InputsType inputsType = Utils.getInputsTypeFromInputs(this.inputs);
        toolType.setInputs(inputsType);
        OutputsType outputsType = Utils.getOutputsTypeFromOutputs(this.outputs);
        toolType.setOutputs(outputsType);
        ToolType.Configfiles configfiles = this.configureFiles.saveAsConfigfiles();
        toolType.setConfigfiles(configfiles);
        return toolType;
    }

    public void setFocus() {
        this.topComposite.setFocus();
    }

    public void dispose() {
        super.dispose();
        this.image.dispose();
    }

    public File getWorkingDirectoryFile() {
        return this.workingDirectoryFile;
    }

    public File getOutputDirectoryFile() {
        return this.outputDirectoryFile;
    }

    public Tool getTool() {
        return this.tool;
    }

    public String getExecuteCommand() {
        return this.executeCommand;
    }

    public HtmlToolOutput getHtmlToolOutput() {
        return this.htmlToolOutput;
    }

    public int[] getTime() {
        return this.time;
    }
}

