/*
 * Decompiled with CFR 0.152.
 */
package com.sixthhosp.gcmpa.editors.paramui;

import com.sixthhosp.gcmpa.editors.ei.HelpEditorInput;
import com.sixthhosp.gcmpa.tools.Tool;
import com.sixthhosp.gcmpa.xmlbeans.tool.ToolType;
import java.io.File;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class ParamHeaderPart {
    private String toolName;
    private String toolDescription;
    private String toolVersion;
    private String helpPath;
    private RGB foregroundRgb = new RGB(188, 52, 52);
    private Composite topComposite;
    private Composite composite;
    private CLabel cLabel;
    private Link helpLink;
    private Tool tool;

    public ParamHeaderPart() {
    }

    public ParamHeaderPart(Tool tool) {
        this();
        this.toolName = tool.getName();
        this.toolDescription = tool.getDescription();
        if (this.toolDescription == null) {
            this.toolDescription = "";
        }
        this.toolVersion = tool.getVersion();
        this.helpPath = tool.getHelpPath();
        this.tool = tool;
    }

    public ParamHeaderPart(ToolType toolType) {
        this();
        this.toolName = toolType.getName();
        this.toolName = this.toolName.replaceAll(" - \\d+$", "");
        this.toolDescription = toolType.getDescription();
        if (this.toolDescription == null) {
            this.toolDescription = "";
        }
        this.toolVersion = toolType.getVersion();
        this.helpPath = toolType.getHelppath();
    }

    public String toString() {
        return "Tool Header: " + this.toolName;
    }

    public void creatContents(Composite parent, Composite topComposite) {
        FontData[] fontDatas;
        this.setTopComposite(topComposite);
        this.composite = new Composite(parent, 0);
        GridData compositeGridData = new GridData(768);
        this.composite.setLayoutData((Object)compositeGridData);
        this.composite.setLayout((Layout)new GridLayout(2, false));
        this.composite.setBackground(this.composite.getDisplay().getSystemColor(1));
        final Color color = new Color((Device)Display.getCurrent(), this.foregroundRgb);
        FontData[] fontDataArray = fontDatas = Display.getCurrent().getSystemFont().getFontData();
        int n = fontDatas.length;
        int n2 = 0;
        while (n2 < n) {
            FontData fontData = fontDataArray[n2];
            fontData.setStyle(1);
            ++n2;
        }
        final Font font = new Font((Device)Display.getCurrent(), fontDatas);
        this.cLabel = new CLabel(this.composite, 0);
        this.cLabel.setForeground(color);
        this.cLabel.setBackground(this.cLabel.getDisplay().getSystemColor(1));
        this.cLabel.setFont(font);
        String text = "Tool:  " + this.toolName + " " + this.toolDescription;
        this.cLabel.setText(text);
        this.composite.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                color.dispose();
                font.dispose();
            }
        });
        this.helpLink = new Link(this.composite, 0);
        this.helpLink.setForeground(color);
        this.helpLink.setBackground(this.helpLink.getDisplay().getSystemColor(1));
        this.helpLink.setFont(font);
        String helpString = "-  <A>Help Link</A>";
        this.helpLink.setText(helpString);
        this.helpLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ParamHeaderPart.this.openHelp();
            }
        });
        this.addMouseDownFoucusEvent();
    }

    public void openHelp() {
        String helpPath = this.tool.getHelpPath();
        if (StringUtils.isNotBlank((String)helpPath) && new File(helpPath).exists()) {
            HelpEditorInput helpEditorInput = new HelpEditorInput(this.tool);
            IWorkbenchPage workbenchPage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            IEditorPart editor = workbenchPage.findEditor((IEditorInput)helpEditorInput);
            if (editor != null) {
                workbenchPage.bringToTop((IWorkbenchPart)editor);
            } else {
                try {
                    workbenchPage.openEditor((IEditorInput)helpEditorInput, "com.sixthhosp.gcmpa.editors.helpeditor");
                }
                catch (PartInitException e) {
                    e.printStackTrace();
                }
            }
        } else {
            MessageDialog.openError((Shell)this.composite.getShell(), (String)this.tool.getName(), (String)"No Tool Help Document");
        }
    }

    private void addMouseDownFoucusEvent() {
        this.composite.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                ParamHeaderPart.this.topComposite.setFocus();
            }
        });
        this.cLabel.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                ParamHeaderPart.this.topComposite.setFocus();
            }
        });
        this.helpLink.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                ParamHeaderPart.this.topComposite.setFocus();
            }
        });
    }

    public String getToolName() {
        return this.toolName;
    }

    public void setToolName(String toolName) {
        this.toolName = toolName;
    }

    public String getToolDescription() {
        return this.toolDescription;
    }

    public void setToolDescription(String toolDescription) {
        this.toolDescription = toolDescription;
    }

    public String getToolVersion() {
        return this.toolVersion;
    }

    public void setToolVersion(String toolVersion) {
        this.toolVersion = toolVersion;
    }

    public String getHelpPath() {
        return this.helpPath;
    }

    public void setHelpPath(String helpPath) {
        this.helpPath = helpPath;
    }

    public RGB getBackgroundRgb() {
        return this.foregroundRgb;
    }

    public void setBackgroundRgb(RGB backgroundRgb) {
        this.foregroundRgb = backgroundRgb;
    }

    public Composite getComposite() {
        return this.composite;
    }

    public void setComposite(Composite composite) {
        this.composite = composite;
    }

    public CLabel getcLabel() {
        return this.cLabel;
    }

    public void setcLabel(CLabel cLabel) {
        this.cLabel = cLabel;
    }

    public Composite getTopComposite() {
        return this.topComposite;
    }

    public void setTopComposite(Composite topComposite) {
        this.topComposite = topComposite;
    }

    public Link getHelpLink() {
        return this.helpLink;
    }

    public void setHelpLink(Link helpLink) {
        this.helpLink = helpLink;
    }
}

