/*
 * Decompiled with CFR 0.152.
 */
package com.sixthhosp.gcmpa.filelock;

import com.sixthhosp.gcmpa.configs.ConfigFile;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import org.apache.commons.io.FileUtils;

public class SoftFileLock {
    private File lockFile = new File(ConfigFile.getLockFilePath());

    public SoftFileLock() {
        File parentFile = this.lockFile.getParentFile();
        try {
            if (!parentFile.exists()) {
                FileUtils.forceMkdir((File)parentFile);
            }
            if (!this.lockFile.exists()) {
                this.lockFile.createNewFile();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public boolean lock() {
        try {
            RandomAccessFile randomAccessFile = new RandomAccessFile(this.lockFile, "rw");
            FileChannel fileChannel = randomAccessFile.getChannel();
            FileLock fileLock = fileChannel.tryLock();
            if (fileLock != null) {
                return true;
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (OverlappingFileLockException e) {
            e.printStackTrace();
        }
        return false;
    }

    public static boolean isLocked() {
        SoftFileLock softFileLock = new SoftFileLock();
        return softFileLock.lock();
    }
}

