/*
 * Decompiled with CFR 0.152.
 */
package com.sixthhosp.gcmpa.tasks;

import com.sixthhosp.gcmpa.tasks.ITask;
import com.sixthhosp.gcmpa.tasks.XmlTask;
import com.sixthhosp.gcmpa.xmlbeans.tasks.TaskType;
import com.sixthhosp.gcmpa.xmlbeans.tasks.TasksType;
import java.util.ArrayList;
import org.apache.commons.lang.ArrayUtils;
import org.apache.xmlbeans.XmlObject;

public class TaskBox {
    private ArrayList<ITask> tasks = new ArrayList();
    private static final int maxTasks = 200;

    public TaskBox() {
    }

    public TaskBox(TasksType tasksType) {
        this();
        TaskType[] types;
        TaskType[] taskTypeArray = types = tasksType.getTaskArray();
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            TaskType type = taskTypeArray[n2];
            XmlTask task = new XmlTask(type);
            this.tasks.add(task);
            ++n2;
        }
    }

    public synchronized void add(ITask task) {
        if (this.tasks.size() < 200) {
            this.tasks.add(task);
        } else {
            ITask e = this.tasks.remove(0);
            e.deleteRelatedFiles();
            this.tasks.add(task);
        }
    }

    public synchronized void delete(ITask task) {
        task.deleteRelatedFiles();
        this.tasks.remove(task);
    }

    public synchronized void deleteAllFiTasks() {
        ArrayList<ITask> list = new ArrayList<ITask>();
        list.addAll(this.tasks);
        for (ITask task : list) {
            if (!task.isAllFinished()) continue;
            task.deleteRelatedFiles();
            this.tasks.remove(task);
        }
    }

    public synchronized ITask[] getTasksArrary() {
        Object[] array = this.tasks.toArray(new ITask[this.tasks.size()]);
        ArrayUtils.reverse((Object[])array);
        return array;
    }

    public synchronized boolean isRunningTasksExist() {
        boolean b = false;
        for (ITask task : this.tasks) {
            if (task.isAllFinished()) continue;
            b = true;
        }
        return b;
    }

    public synchronized void stopAllNotFinishedTasks() {
        for (ITask task : this.tasks) {
            if (task.isAllFinished() || !task.canStop()) continue;
            task.stop();
        }
    }

    public synchronized ArrayList<ITask> getTasks() {
        return this.tasks;
    }

    public synchronized TasksType saveASTasksType() {
        TasksType tasksType = TasksType.Factory.newInstance();
        for (ITask task : this.tasks) {
            XmlTask xmlTask;
            if (!(task instanceof XmlTask) || !(xmlTask = (XmlTask)task).isAllFinished()) continue;
            tasksType.addNewTask().set((XmlObject)xmlTask.saveAsTaskType());
        }
        return tasksType;
    }
}

