/*
 * Decompiled with CFR 0.152.
 */
package com.sixthhosp.gcmpa.tasks;

import com.sixthhosp.gcmpa.configs.ConfigFile;
import com.sixthhosp.gcmpa.configs.Utils;
import com.sixthhosp.gcmpa.editors.ParamEditor;
import com.sixthhosp.gcmpa.tasks.ITask;
import com.sixthhosp.gcmpa.views.TasksView;
import com.sixthhosp.gcmpa.xmlbeans.tasks.TaskType;
import com.sixthhosp.gcmpa.xmlbeans.tool.ToolDocument;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.exec.DefaultExecuteResultHandler;
import org.apache.commons.exec.DefaultExecutor;
import org.apache.commons.exec.ExecuteException;
import org.apache.commons.exec.ExecuteResultHandler;
import org.apache.commons.exec.ExecuteStreamHandler;
import org.apache.commons.exec.ExecuteWatchdog;
import org.apache.commons.exec.PumpStreamHandler;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.PlatformUI;

public class XmlTask
implements ITask {
    public static int jobsNum = 0;
    private String id;
    private String xmlinfopath;
    private String taskname;
    private String taskstate;
    private String starttime;
    private String endtime;
    private String commandline;
    private String stderrpath;
    private String stdoutpath;
    private String htmloutpath;
    private String outputsfolderpath;
    private String taskfolderpath;
    private ParamEditor paramEditor;
    private TableViewer tableViewer;
    private String workingDirPath;
    private File workingDirFile;
    private boolean allFinished;
    private ExecuteWatchdog watchdog;

    public XmlTask() {
        IViewPart viewPart = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findView("com.sixthhosp.gcmpa.views.taskview");
        Assert.isNotNull((Object)viewPart);
        TasksView tasksView = (TasksView)viewPart;
        this.tableViewer = tasksView.getTaskTableViewer();
    }

    public XmlTask(TaskType taskType) {
        this();
        this.id = taskType.getId();
        this.xmlinfopath = taskType.getXmlinfopath();
        this.taskname = taskType.getTaskname();
        this.taskstate = taskType.getTaskstate();
        this.starttime = taskType.getStarttime();
        this.endtime = taskType.getEndtime();
        this.commandline = taskType.getCommandline();
        this.stderrpath = taskType.getStderrpath();
        this.stdoutpath = taskType.getStdoutpath();
        this.htmloutpath = taskType.getHtmloutpath();
        this.outputsfolderpath = taskType.getOutputsfolderpath();
        this.taskfolderpath = taskType.getTaskfolderpath();
        this.allFinished = true;
    }

    public XmlTask(ParamEditor paramEditor) {
        this();
        this.paramEditor = paramEditor;
        this.id = Utils.getRandomStringByUUID();
        this.taskfolderpath = String.valueOf(ConfigFile.getTaskInfoFolderPath()) + "/" + this.id;
        this.xmlinfopath = String.valueOf(this.taskfolderpath) + "/module.xml";
        this.taskname = paramEditor.getTool().getName();
        this.commandline = paramEditor.getExecuteCommand();
        this.stderrpath = String.valueOf(this.taskfolderpath) + "/stdout.log";
        this.stdoutpath = String.valueOf(this.taskfolderpath) + "/stderr.log";
        this.htmloutpath = paramEditor.getHtmlToolOutput().getAbsOutputFilePath();
        this.outputsfolderpath = paramEditor.getOutputDirectoryFile().getAbsolutePath();
        this.taskstate = "Waiting";
        this.allFinished = false;
        this.workingDirFile = paramEditor.getWorkingDirectoryFile();
        this.workingDirPath = this.workingDirFile.getAbsolutePath();
    }

    @Override
    public boolean isAllFinished() {
        return this.allFinished;
    }

    @Override
    public void start() {
        try {
            String t;
            this.allFinished = false;
            FileUtils.forceMkdir((File)this.workingDirFile);
            FileUtils.forceMkdir((File)new File(this.outputsfolderpath));
            FileUtils.forceMkdir((File)new File(this.taskfolderpath));
            File shellFile = new File(String.valueOf(this.workingDirPath) + File.separator + "run.sh");
            FileUtils.writeStringToFile((File)shellFile, (String)this.commandline);
            CommandLine commandLine = CommandLine.parse((String)("sh \"" + shellFile.getAbsolutePath() + "\""));
            DefaultExecutor executor = new DefaultExecutor();
            executor.setWorkingDirectory(this.workingDirFile);
            this.watchdog = new ExecuteWatchdog(-1L);
            executor.setWatchdog(this.watchdog);
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            ByteArrayOutputStream errorStream = new ByteArrayOutputStream();
            PumpStreamHandler streamHandler = new PumpStreamHandler((OutputStream)outputStream, (OutputStream)errorStream);
            executor.setStreamHandler((ExecuteStreamHandler)streamHandler);
            DefaultExecuteResultHandler resultHandler = new DefaultExecuteResultHandler();
            int[] time = this.paramEditor.getTime();
            this.starttime = t = String.valueOf(time[0]) + "/" + time[1] + "/" + time[2] + "-" + time[3] + ":" + time[4] + ":" + time[5];
            executor.execute(commandLine, (ExecuteResultHandler)resultHandler);
            this.taskstate = "Running";
            this.refreshTaskBrowser();
            resultHandler.waitFor();
            this.taskstate = this.watchdog.killedProcess() ? "Terminated" : (resultHandler.getExitValue() != 0 ? "Failed" : "Finished");
            FileOutputStream stdoutFileOutputStream = new FileOutputStream(new File(this.stdoutpath));
            FileOutputStream stderrFileOutputStream = new FileOutputStream(new File(this.stderrpath));
            outputStream.writeTo(stdoutFileOutputStream);
            errorStream.writeTo(stderrFileOutputStream);
            this.saveToolXml();
            this.endtime = Utils.getCurrentTime();
            this.refreshTaskBrowser();
            FileUtils.deleteQuietly((File)this.workingDirFile);
            this.allFinished = true;
        }
        catch (ExecuteException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    @Override
    public boolean canStop() {
        return this.taskstate.equals("Running");
    }

    @Override
    public void stop() {
        if (this.watchdog.isWatching()) {
            this.watchdog.destroyProcess();
        }
    }

    private void refreshTaskBrowser() {
        if (this.tableViewer != null && !this.tableViewer.getTable().isDisposed()) {
            this.tableViewer.getTable().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (XmlTask.this.tableViewer != null && !XmlTask.this.tableViewer.getTable().isDisposed()) {
                        XmlTask.this.tableViewer.refresh();
                    }
                }
            });
        }
    }

    @Override
    public void deleteRelatedFiles() {
        File file;
        if (StringUtils.isNotBlank((String)this.xmlinfopath) && (file = new File(this.xmlinfopath)).exists()) {
            FileUtils.deleteQuietly((File)file);
        }
        if (StringUtils.isNotBlank((String)this.stdoutpath) && (file = new File(this.stdoutpath)).exists()) {
            FileUtils.deleteQuietly((File)file);
        }
        if (StringUtils.isNotBlank((String)this.stderrpath) && (file = new File(this.stderrpath)).exists()) {
            FileUtils.deleteQuietly((File)file);
        }
        if (StringUtils.isNotBlank((String)this.taskfolderpath) && (file = new File(this.taskfolderpath)).exists()) {
            FileUtils.deleteQuietly((File)file);
        }
    }

    public TaskType saveAsTaskType() {
        TaskType taskType = TaskType.Factory.newInstance();
        taskType.setId(this.id);
        taskType.setXmlinfopath(this.xmlinfopath);
        taskType.setTaskname(this.taskname);
        taskType.setTaskstate(this.taskstate);
        if (this.starttime == null) {
            taskType.setStarttime("");
        } else {
            taskType.setStarttime(this.starttime);
        }
        if (this.endtime == null) {
            taskType.setEndtime(this.endtime);
        } else {
            taskType.setEndtime(this.endtime);
        }
        taskType.setCommandline(this.commandline);
        taskType.setStdoutpath(this.stdoutpath);
        taskType.setStderrpath(this.stderrpath);
        taskType.setHtmloutpath(this.htmloutpath);
        taskType.setOutputsfolderpath(this.outputsfolderpath);
        taskType.setTaskfolderpath(this.taskfolderpath);
        return taskType;
    }

    public void saveToolXml() {
        try {
            ToolDocument toolDocument = ToolDocument.Factory.newInstance();
            toolDocument.setTool(this.paramEditor.saveAsToolType());
            toolDocument.save(new File(this.xmlinfopath));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getXmlinfopath() {
        return this.xmlinfopath;
    }

    public void setXmlinfopath(String xmlinfopath) {
        this.xmlinfopath = xmlinfopath;
    }

    public String getTaskname() {
        return this.taskname;
    }

    public void setTaskname(String taskname) {
        this.taskname = taskname;
    }

    public String getTaskstate() {
        return this.taskstate;
    }

    public void setTaskstate(String taskstate) {
        this.taskstate = taskstate;
    }

    public String getStarttime() {
        return this.starttime;
    }

    public void setStarttime(String starttime) {
        this.starttime = starttime;
    }

    public String getEndtime() {
        return this.endtime;
    }

    public void setEndtime(String endtime) {
        this.endtime = endtime;
    }

    public String getCommandline() {
        return this.commandline;
    }

    public void setCommandline(String commandline) {
        this.commandline = commandline;
    }

    public String getStderrpath() {
        return this.stderrpath;
    }

    public void setStderrpath(String stderrpath) {
        this.stderrpath = stderrpath;
    }

    public String getStdoutpath() {
        return this.stdoutpath;
    }

    public void setStdoutpath(String stdoutpath) {
        this.stdoutpath = stdoutpath;
    }

    public String getHtmloutpath() {
        return this.htmloutpath;
    }

    public void setHtmloutpath(String htmloutpath) {
        this.htmloutpath = htmloutpath;
    }

    public String getOutputsfolderpath() {
        return this.outputsfolderpath;
    }

    public void setOutputsfolderpath(String outputsfolderpath) {
        this.outputsfolderpath = outputsfolderpath;
    }

    public String getTaskfolderpath() {
        return this.taskfolderpath;
    }

    public void setTaskfolderpath(String taskfolderpath) {
        this.taskfolderpath = taskfolderpath;
    }

    public String getWorkingDirPath() {
        return this.workingDirPath;
    }

    public void setWorkingDirPath(String workingDirPath) {
        this.workingDirPath = workingDirPath;
    }

    public TableViewer getTableViewer() {
        return this.tableViewer;
    }

    public static synchronized void addJobsNum() {
        ++jobsNum;
    }

    public static synchronized void minusJobsNum() {
        --jobsNum;
    }
}

