/*
 * Decompiled with CFR 0.152.
 */
package com.sixthhosp.gcmpa.tools;

import com.sixthhosp.gcmpa.configs.ConfigFile;
import com.sixthhosp.gcmpa.tools.ToolSection;
import com.sixthhosp.gcmpa.xmlbeans.tool.ToolDocument;
import com.sixthhosp.gcmpa.xmlbeans.tool.ToolType;
import java.io.File;
import java.io.IOException;
import org.apache.commons.lang.StringUtils;
import org.apache.xmlbeans.XmlException;

public class Tool {
    private String id;
    private String name;
    private String version;
    private String description;
    private String help;
    private String helpPath;
    private String icon;
    private String iconPath;
    private ToolSection toolSection;
    private String file;
    private String filePath;

    public Tool(com.sixthhosp.gcmpa.xmlbeans.toolconf.ToolType toolType, ToolSection toolSection) {
        this.setFile(toolType.getFile());
        this.setHelp(toolType.getHelp());
        this.setIcon(toolType.getIcon());
        this.setToolSection(toolSection);
        this.helpPath = StringUtils.isBlank((String)this.help) ? "" : new File(String.valueOf(ConfigFile.getSoftFolderPath()) + "/" + this.help).getAbsolutePath();
        this.filePath = new File(String.valueOf(ConfigFile.getSoftFolderPath()) + "/" + this.file).getAbsolutePath();
        this.iconPath = StringUtils.isBlank((String)this.icon) ? "" : new File(String.valueOf(ConfigFile.getSoftFolderPath()) + "/" + this.icon).getAbsolutePath();
        File toolXMLFile = new File(this.filePath);
        try {
            ToolDocument toolDocument = ToolDocument.Factory.parse((File)toolXMLFile);
            ToolType tool = toolDocument.getTool();
            this.setId(tool.getId());
            this.setName(tool.getName());
            this.setVersion(tool.getVersion());
            this.setDescription(tool.getDescription());
            if (this.description == null) {
                this.description = "";
            }
        }
        catch (XmlException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public Tool(ToolType toolType, String xmlPath) {
        this.helpPath = toolType.getHelppath();
        this.iconPath = toolType.getIconpath();
        this.filePath = xmlPath;
        this.setId(toolType.getId());
        this.setName(toolType.getName());
        this.setVersion(toolType.getVersion());
        this.setDescription(toolType.getDescription());
    }

    public String toString() {
        return "Tool: " + this.name;
    }

    public void setFile(String file) {
        this.file = file;
    }

    public void setHelp(String help) {
        this.help = help;
    }

    public void setIcon(String icon) {
        this.icon = icon;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public ToolSection getToolSection() {
        return this.toolSection;
    }

    public void setToolSection(ToolSection toolSection) {
        this.toolSection = toolSection;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getPath() {
        return this.filePath;
    }

    public void setPath(String path) {
        this.filePath = path;
    }

    public String getHelpPath() {
        return this.helpPath;
    }

    public void setHelpPath(String helpPath) {
        this.helpPath = helpPath;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getIconPath() {
        return this.iconPath;
    }

    public void setIconPath(String iconPath) {
        this.iconPath = iconPath;
    }

    public String getFilePath() {
        return this.filePath;
    }

    public void setFilePath(String filePath) {
        this.filePath = filePath;
    }
}

