/*
 * Decompiled with CFR 0.152.
 */
package com.sixthhosp.gcmpa.tools;

import com.sixthhosp.gcmpa.configs.ConfigFile;
import com.sixthhosp.gcmpa.tools.parameters.Conditional;
import com.sixthhosp.gcmpa.tools.parameters.DataToolOutput;
import com.sixthhosp.gcmpa.tools.parameters.DataToolParameter;
import com.sixthhosp.gcmpa.tools.parameters.DataToolParameterEncapsulation;
import com.sixthhosp.gcmpa.tools.parameters.HtmlToolOutput;
import com.sixthhosp.gcmpa.tools.parameters.Repeat;
import com.sixthhosp.gcmpa.tools.parameters.ToolOutput;
import com.sixthhosp.gcmpa.tools.parameters.ToolParameter;
import com.sixthhosp.gcmpa.xmlbeans.tool.ConditionalType;
import com.sixthhosp.gcmpa.xmlbeans.tool.DataType;
import com.sixthhosp.gcmpa.xmlbeans.tool.HtmlType;
import com.sixthhosp.gcmpa.xmlbeans.tool.InputsType;
import com.sixthhosp.gcmpa.xmlbeans.tool.OutputsType;
import com.sixthhosp.gcmpa.xmlbeans.tool.ParamType;
import com.sixthhosp.gcmpa.xmlbeans.tool.RepeatType;
import com.sixthhosp.gcmpa.xmlbeans.tool.UnitType;
import com.sixthhosp.gcmpa.xmlbeans.tool.WhenType;
import java.io.File;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.transform.sax.SAXSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.apache.xmlbeans.QNameSet;
import org.apache.xmlbeans.QNameSetBuilder;
import org.apache.xmlbeans.XmlObject;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.widgets.Composite;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class Utils {
    private static QNameSet sectionAllQnameSet;
    private static QNameSet inputsAllQnameSet;

    private Utils() {
    }

    public static QNameSet getSectionAllQnameSet() {
        if (sectionAllQnameSet == null) {
            QNameSetBuilder qnsb = new QNameSetBuilder();
            qnsb.add(new QName("tool"));
            qnsb.add(new QName("label"));
            qnsb.add(new QName("section"));
            sectionAllQnameSet = qnsb.toQNameSet();
        }
        return sectionAllQnameSet;
    }

    public static QNameSet getInputsAllQnameSet() {
        if (inputsAllQnameSet == null) {
            QNameSetBuilder qnsb = new QNameSetBuilder();
            qnsb.add(new QName("param"));
            qnsb.add(new QName("conditional"));
            qnsb.add(new QName("repeat"));
            inputsAllQnameSet = qnsb.toQNameSet();
        }
        return inputsAllQnameSet;
    }

    public static void reSize(Composite topComposite) {
        ScrolledComposite scrolledComposite = (ScrolledComposite)topComposite.getParent();
        scrolledComposite.setMinSize(topComposite.computeSize(-1, -1));
    }

    public static LinkedHashMap<String, Object> parseInputElement(XmlObject[] xmlObjects) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        XmlObject[] xmlObjectArray = xmlObjects;
        int n = xmlObjects.length;
        int n2 = 0;
        while (n2 < n) {
            String name;
            XmlObject xmlObject = xmlObjectArray[n2];
            if (xmlObject instanceof ParamType) {
                ParamType paramType = (ParamType)xmlObject;
                ToolParameter toolParameter = ToolParameter.init(paramType);
                name = toolParameter.getName();
                map.put(name, toolParameter);
            } else if (xmlObject instanceof ConditionalType) {
                ConditionalType conditionalType = (ConditionalType)xmlObject;
                Conditional conditionalParameter = new Conditional(conditionalType);
                name = conditionalParameter.getName();
                map.put(name, conditionalParameter);
            } else if (xmlObject instanceof RepeatType) {
                RepeatType repeatType = (RepeatType)xmlObject;
                Repeat repeatParameter = new Repeat(repeatType);
                name = repeatParameter.getName();
                map.put(name, repeatParameter);
            } else {
                throw new RuntimeException("unknown inputs");
            }
            ++n2;
        }
        return map;
    }

    public static LinkedHashMap<String, Object> parseInputsType(InputsType inputsType) {
        XmlObject[] xmlObjects = inputsType.selectChildren(Utils.getInputsAllQnameSet());
        return Utils.parseInputElement(xmlObjects);
    }

    public static LinkedHashMap<String, ToolOutput> parseOutputsType(OutputsType outputsType) {
        DataType[] dataTypes;
        LinkedHashMap<String, ToolOutput> map = new LinkedHashMap<String, ToolOutput>();
        DataType[] dataTypeArray = dataTypes = outputsType.getDataArray();
        int n = dataTypes.length;
        int n2 = 0;
        while (n2 < n) {
            DataType dataType = dataTypeArray[n2];
            DataToolOutput dataToolOutput = new DataToolOutput(dataType);
            map.put(dataToolOutput.getName(), dataToolOutput);
            ++n2;
        }
        HtmlType htmlType = outputsType.getHtml();
        HtmlToolOutput htmlToolOutput = new HtmlToolOutput(htmlType);
        map.put(htmlToolOutput.getName(), htmlToolOutput);
        return map;
    }

    public static void creatInputsContents(LinkedHashMap<String, Object> inputs, Composite parent, Composite topComposite) {
        Iterator<Map.Entry<String, Object>> iterator = inputs.entrySet().iterator();
        while (iterator.hasNext()) {
            Object object = iterator.next().getValue();
            if (object instanceof ToolParameter) {
                ToolParameter toolParameter = (ToolParameter)object;
                toolParameter.creatContents(parent, topComposite);
                continue;
            }
            if (object instanceof Repeat) {
                Repeat repeat = (Repeat)object;
                repeat.clearWidgetArrayList();
                repeat.creatContents(parent, topComposite);
                continue;
            }
            if (object instanceof Conditional) {
                Conditional conditional = (Conditional)object;
                conditional.creatContents(parent, topComposite);
                continue;
            }
            throw new RuntimeException("unknown inputs");
        }
    }

    public static void doSaveForInputs(LinkedHashMap<String, Object> inputs) {
        Iterator<Map.Entry<String, Object>> iterator = inputs.entrySet().iterator();
        while (iterator.hasNext()) {
            Object object = iterator.next().getValue();
            if (object instanceof ToolParameter) {
                ToolParameter toolParameter = (ToolParameter)object;
                toolParameter.doSave();
                continue;
            }
            if (object instanceof Repeat) {
                Repeat repeat = (Repeat)object;
                repeat.doSave();
                continue;
            }
            if (object instanceof Conditional) {
                Conditional conditional = (Conditional)object;
                conditional.doSave();
                continue;
            }
            throw new RuntimeException("unknown inputs");
        }
    }

    public static void setOutDirectoryPathForOutputs(LinkedHashMap<String, ToolOutput> outputs, String outDirectory) {
        Iterator<Map.Entry<String, ToolOutput>> iterator = outputs.entrySet().iterator();
        while (iterator.hasNext()) {
            ToolOutput toolOutput = iterator.next().getValue();
            toolOutput.setOutDirectory(outDirectory);
        }
    }

    public static void doSaveForOutputs(LinkedHashMap<String, ToolOutput> outputs) {
        Iterator<Map.Entry<String, ToolOutput>> iterator = outputs.entrySet().iterator();
        while (iterator.hasNext()) {
            ToolOutput toolOutput = iterator.next().getValue();
            toolOutput.doSave();
        }
    }

    public static HtmlToolOutput getHtmlToolOutput(LinkedHashMap<String, ToolOutput> outputs) {
        Iterator<Map.Entry<String, ToolOutput>> iterator = outputs.entrySet().iterator();
        while (iterator.hasNext()) {
            ToolOutput toolOutput = iterator.next().getValue();
            if (!(toolOutput instanceof HtmlToolOutput)) continue;
            return (HtmlToolOutput)toolOutput;
        }
        return null;
    }

    public static ArrayList<DataToolOutput> getDataToolOutputs(LinkedHashMap<String, ToolOutput> outputs) {
        Iterator<Map.Entry<String, ToolOutput>> iterator = outputs.entrySet().iterator();
        ArrayList<DataToolOutput> dataToolOutputs = new ArrayList<DataToolOutput>();
        while (iterator.hasNext()) {
            ToolOutput toolOutput = iterator.next().getValue();
            if (!(toolOutput instanceof DataToolOutput)) continue;
            dataToolOutputs.add((DataToolOutput)toolOutput);
        }
        return dataToolOutputs;
    }

    public static HashMap<String, Object> getDataModelFromInputs(LinkedHashMap<String, Object> inputs) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Iterator<Map.Entry<String, Object>> iterator = inputs.entrySet().iterator();
        while (iterator.hasNext()) {
            Object object = iterator.next().getValue();
            if (object instanceof ToolParameter) {
                ToolParameter toolParameter = (ToolParameter)object;
                map.putAll(toolParameter.getDataModelMap());
                continue;
            }
            if (object instanceof Repeat) {
                Repeat repeat = (Repeat)object;
                map.putAll(repeat.getDataModelMap());
                continue;
            }
            if (object instanceof Conditional) {
                Conditional conditional = (Conditional)object;
                map.putAll(conditional.getDataModelMap());
                continue;
            }
            throw new RuntimeException("unknown inputs");
        }
        return map;
    }

    public static HashMap<String, String> getDataModelFromOutputs(LinkedHashMap<String, ToolOutput> outputs) {
        HashMap<String, String> map = new HashMap<String, String>();
        Iterator<Map.Entry<String, ToolOutput>> iterator = outputs.entrySet().iterator();
        while (iterator.hasNext()) {
            ToolOutput toolOutput = iterator.next().getValue();
            map.putAll(toolOutput.getDataModelMap());
        }
        return map;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void addInputsXMLObjectsToParentObject(XmlObject parent, XmlObject child) {
        if (parent instanceof RepeatType) {
            RepeatType repeatType = (RepeatType)parent;
            if (child instanceof ParamType) {
                repeatType.addNewParam().set(child);
                return;
            } else if (child instanceof RepeatType) {
                repeatType.addNewRepeat().set(child);
                return;
            } else {
                if (!(child instanceof ConditionalType)) throw new RuntimeException("child type error");
                repeatType.addNewConditional().set(child);
            }
            return;
        } else if (parent instanceof InputsType) {
            InputsType inputsType = (InputsType)parent;
            if (child instanceof ParamType) {
                inputsType.addNewParam().set(child);
                return;
            } else if (child instanceof RepeatType) {
                inputsType.addNewRepeat().set(child);
                return;
            } else {
                if (!(child instanceof ConditionalType)) throw new RuntimeException("child type error");
                inputsType.addNewConditional().set(child);
            }
            return;
        } else if (parent instanceof WhenType) {
            WhenType whenType = (WhenType)parent;
            if (child instanceof ParamType) {
                whenType.addNewParam().set(child);
                return;
            } else if (child instanceof RepeatType) {
                whenType.addNewRepeat().set(child);
                return;
            } else {
                if (!(child instanceof ConditionalType)) throw new RuntimeException("child type error");
                whenType.addNewConditional().set(child);
            }
            return;
        } else {
            if (!(parent instanceof UnitType)) throw new RuntimeException("parent type error");
            UnitType unitType = (UnitType)parent;
            if (child instanceof ParamType) {
                unitType.addNewParam().set(child);
                return;
            } else if (child instanceof RepeatType) {
                unitType.addNewRepeat().set(child);
                return;
            } else {
                if (!(child instanceof ConditionalType)) throw new RuntimeException("child type error");
                unitType.addNewConditional().set(child);
            }
        }
    }

    public static ArrayList<XmlObject> getXmlObjectsFromInputs(LinkedHashMap<String, Object> inputs) {
        ArrayList<XmlObject> list = new ArrayList<XmlObject>();
        Iterator<Map.Entry<String, Object>> iterator = inputs.entrySet().iterator();
        while (iterator.hasNext()) {
            Object object = iterator.next().getValue();
            if (object instanceof ToolParameter) {
                ToolParameter toolParameter = (ToolParameter)object;
                list.add((XmlObject)toolParameter.saveAsParamType());
                continue;
            }
            if (object instanceof Repeat) {
                Repeat repeat = (Repeat)object;
                list.add((XmlObject)repeat.saveAsRepeatType());
                continue;
            }
            if (object instanceof Conditional) {
                Conditional conditional = (Conditional)object;
                list.add((XmlObject)conditional.saveAsConditionalType());
                continue;
            }
            throw new RuntimeException("unknown inputs");
        }
        return list;
    }

    public static boolean startValidatingForInputs(LinkedHashMap<String, Object> inputs) {
        boolean b = true;
        Iterator<Map.Entry<String, Object>> iterator = inputs.entrySet().iterator();
        while (iterator.hasNext()) {
            Object object = iterator.next().getValue();
            if (object instanceof ToolParameter) {
                ToolParameter toolParameter = (ToolParameter)object;
                if (toolParameter.startValidating()) continue;
                b = false;
                continue;
            }
            if (object instanceof Repeat) {
                Repeat repeat = (Repeat)object;
                if (repeat.startValidating()) continue;
                b = false;
                continue;
            }
            if (object instanceof Conditional) {
                Conditional conditional = (Conditional)object;
                if (conditional.startValidating()) continue;
                b = false;
                continue;
            }
            throw new RuntimeException("unknown inputs");
        }
        return b;
    }

    public static boolean validateSavedValueForInputs(LinkedHashMap<String, Object> inputs) {
        boolean b = true;
        Iterator<Map.Entry<String, Object>> iterator = inputs.entrySet().iterator();
        while (iterator.hasNext()) {
            Object object = iterator.next().getValue();
            if (object instanceof ToolParameter) {
                ToolParameter toolParameter = (ToolParameter)object;
                if (toolParameter.validateSavedValue()) continue;
                b = false;
                continue;
            }
            if (object instanceof Repeat) {
                Repeat repeat = (Repeat)object;
                if (repeat.validateSavedValue()) continue;
                b = false;
                continue;
            }
            if (object instanceof Conditional) {
                Conditional conditional = (Conditional)object;
                if (conditional.validateSavedValue()) continue;
                b = false;
                continue;
            }
            throw new RuntimeException("unknown inputs");
        }
        return b;
    }

    public static void registerLabelDataWidgetForInputs(LinkedHashMap<String, Object> inputs) {
        Iterator<Map.Entry<String, Object>> iterator = inputs.entrySet().iterator();
        while (iterator.hasNext()) {
            Object object = iterator.next().getValue();
            if (object instanceof ToolParameter) {
                if (!(object instanceof DataToolParameter)) continue;
                DataToolParameter dataToolParameter = (DataToolParameter)object;
                dataToolParameter.registerLabelDataWidget();
                continue;
            }
            if (object instanceof Repeat) {
                Repeat repeat = (Repeat)object;
                repeat.registerLabelDataWidget();
                continue;
            }
            if (object instanceof Conditional) {
                Conditional conditional = (Conditional)object;
                conditional.registerLabelDataWidget();
                continue;
            }
            throw new RuntimeException("unknown inputs");
        }
    }

    public static void registerAlwaysValidatingForInputs(LinkedHashMap<String, Object> inputs) {
        Iterator<Map.Entry<String, Object>> iterator = inputs.entrySet().iterator();
        while (iterator.hasNext()) {
            Object object = iterator.next().getValue();
            if (object instanceof ToolParameter) {
                ToolParameter toolParameter = (ToolParameter)object;
                toolParameter.registerAlwaysValidating();
                continue;
            }
            if (object instanceof Repeat) {
                Repeat repeat = (Repeat)object;
                repeat.registerAlwaysValidating();
                continue;
            }
            if (object instanceof Conditional) {
                Conditional conditional = (Conditional)object;
                conditional.registerAlwaysValidating();
                continue;
            }
            throw new RuntimeException("unknown inputs");
        }
    }

    public static void clearDataToolParameterSavedVauleForInputs(LinkedHashMap<String, Object> inputs) {
        Iterator<Map.Entry<String, Object>> iterator = inputs.entrySet().iterator();
        while (iterator.hasNext()) {
            Object object = iterator.next().getValue();
            if (object instanceof ToolParameter) {
                if (!(object instanceof DataToolParameter)) continue;
                DataToolParameter dataToolParameter = (DataToolParameter)object;
                dataToolParameter.clearSavedVaule();
                continue;
            }
            if (object instanceof Repeat) {
                Repeat repeat = (Repeat)object;
                repeat.clearDataToolParameterSavedVaule();
                continue;
            }
            if (object instanceof Conditional) {
                Conditional conditional = (Conditional)object;
                conditional.clearDataToolParameterSavedVaule();
                continue;
            }
            throw new RuntimeException("unknown inputs");
        }
    }

    public static InputsType getInputsTypeFromInputs(LinkedHashMap<String, Object> inputs) {
        InputsType inputsType = InputsType.Factory.newInstance();
        ArrayList<XmlObject> xmlObjects = Utils.getXmlObjectsFromInputs(inputs);
        for (XmlObject child : xmlObjects) {
            Utils.addInputsXMLObjectsToParentObject((XmlObject)inputsType, child);
        }
        return inputsType;
    }

    public static ArrayList<DataToolParameterEncapsulation> getDataToolParameterEncapsulationListFromInputs(LinkedHashMap<String, Object> inputs, String labelPrefix) {
        ArrayList<DataToolParameterEncapsulation> list = new ArrayList<DataToolParameterEncapsulation>();
        Iterator<Map.Entry<String, Object>> iterator = inputs.entrySet().iterator();
        while (iterator.hasNext()) {
            Object object = iterator.next().getValue();
            if (object instanceof ToolParameter) {
                if (!(object instanceof DataToolParameter)) continue;
                DataToolParameter dataToolParameter = (DataToolParameter)object;
                String label = String.valueOf(labelPrefix) + dataToolParameter.getLabel();
                list.add(new DataToolParameterEncapsulation(label, dataToolParameter));
                continue;
            }
            if (object instanceof Repeat) {
                Repeat repeat = (Repeat)object;
                list.addAll(repeat.getDataToolParameterEncapsulationList(labelPrefix));
                continue;
            }
            if (object instanceof Conditional) {
                Conditional conditional = (Conditional)object;
                list.addAll(conditional.getDataToolParameterEncapsulationList(labelPrefix));
                continue;
            }
            throw new RuntimeException("unknown inputs");
        }
        return list;
    }

    public static void validateToolXML(String toolXml) throws Exception {
        String xsdPath = String.valueOf(ConfigFile.getProjectFolderPath()) + "/configs/tool.xsd";
        File documentFile = new File(toolXml);
        File schemaFile = new File(xsdPath);
        SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        Schema schema = null;
        try {
            schema = factory.newSchema(schemaFile);
        }
        catch (SAXException e) {
            Utils.fail(e);
        }
        Validator validator = schema.newValidator();
        SAXSource source = new SAXSource(new InputSource(new FileReader(documentFile)));
        try {
            validator.validate(source);
        }
        catch (SAXException e) {
            Utils.fail(e);
        }
    }

    private static void fail(SAXException e) throws Exception {
        if (e instanceof SAXParseException) {
            SAXParseException spe = (SAXParseException)e;
            throw new Exception("LineNumber: " + spe.getLineNumber() + "  ColumnNumber: " + spe.getColumnNumber() + "\n" + spe.getMessage() + "\n");
        }
        throw new Exception(e.getMessage());
    }

    public static OutputsType getOutputsTypeFromOutputs(LinkedHashMap<String, ToolOutput> outputs) {
        OutputsType outputsType = OutputsType.Factory.newInstance();
        Iterator<Map.Entry<String, ToolOutput>> iterator = outputs.entrySet().iterator();
        while (iterator.hasNext()) {
            ToolOutput toolOutput = iterator.next().getValue();
            if (toolOutput instanceof DataToolOutput) {
                DataType dataType = ((DataToolOutput)toolOutput).saveAsDataType();
                outputsType.addNewData().set((XmlObject)dataType);
                continue;
            }
            if (toolOutput instanceof HtmlToolOutput) {
                HtmlType htmlType = ((HtmlToolOutput)toolOutput).saveAsHtmlType();
                outputsType.addNewHtml().set((XmlObject)htmlType);
                continue;
            }
            throw new RuntimeException("unknown output");
        }
        return outputsType;
    }
}

