/*
 * Decompiled with CFR 0.152.
 */
package com.sixthhosp.gcmpa.tools.misc;

import com.sixthhosp.gcmpa.tools.template.TemplateEngine;
import com.sixthhosp.gcmpa.xmlbeans.tool.ToolType;
import java.util.HashMap;
import org.apache.commons.lang.StringUtils;

public class CommandLine {
    private String template;
    private String interpreter;
    private String commandLineContent;

    public CommandLine() {
    }

    public CommandLine(ToolType.Command command) {
        this.interpreter = command.getInterpreter();
        if (StringUtils.isBlank((String)this.interpreter)) {
            this.interpreter = "";
        }
        this.template = command.getStringValue();
    }

    public String toString() {
        return "Module Command Line";
    }

    public void velocityinterpolate(HashMap<String, Object> dataModel) {
        String string = TemplateEngine.combineDataModelAndTemplate(dataModel, this.template);
        string = string.replaceAll("\\n", " ").replaceAll("\\r", " ");
        this.commandLineContent = string = StringUtils.trimToEmpty((String)string);
    }

    public String getExecuteCommandLine() {
        if (StringUtils.isBlank((String)this.interpreter)) {
            return this.commandLineContent;
        }
        return String.valueOf(this.interpreter) + " " + this.commandLineContent;
    }

    public ToolType.Command saveAsCommand() {
        ToolType.Command command = ToolType.Command.Factory.newInstance();
        if (StringUtils.isNotBlank((String)this.interpreter)) {
            command.setInterpreter(this.interpreter);
        }
        command.setStringValue(this.template);
        return command;
    }

    public String getTemplate() {
        return this.template;
    }

    public void setTemplate(String template) {
        this.template = template;
    }

    public String getInterpreter() {
        return this.interpreter;
    }

    public void setInterpreter(String interpreter) {
        this.interpreter = interpreter;
    }

    public String getCommandLineContent() {
        return this.commandLineContent;
    }

    public void setCommandLineContent(String commandLineContent) {
        this.commandLineContent = commandLineContent;
    }
}

