/*
 * Decompiled with CFR 0.152.
 */
package com.sixthhosp.gcmpa.tools.misc;

import com.sixthhosp.gcmpa.configs.Utils;
import com.sixthhosp.gcmpa.tools.template.TemplateEngine;
import com.sixthhosp.gcmpa.xmlbeans.tool.ToolType;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import org.apache.commons.io.FileUtils;

public class ConfigureFile {
    private String content;
    private String name;
    private String workingDirectoryPath;
    private String configFileAbsPath;

    public ConfigureFile() {
    }

    public ConfigureFile(ToolType.Configfiles.Configfile configfile) {
        this();
        this.name = configfile.getName();
        this.content = configfile.getStringValue();
    }

    public ConfigureFile(ToolType.Configfiles.Configfile configfile, String workingDirectoryPath) {
        this(configfile);
        this.workingDirectoryPath = workingDirectoryPath;
    }

    public String toString() {
        return "Config: " + this.name + "\nPath: " + this.configFileAbsPath;
    }

    public void generateConfigFile(HashMap<String, Object> dataModel) {
        try {
            File dir = new File(this.workingDirectoryPath);
            if (!dir.exists()) {
                FileUtils.forceMkdir((File)dir);
            }
            File file = new File(String.valueOf(this.workingDirectoryPath) + "/" + Utils.getRandomStringByUUID() + ".txt");
            this.configFileAbsPath = file.getAbsolutePath();
            String string = TemplateEngine.combineDataModelAndTemplate(dataModel, this.content);
            FileUtils.writeStringToFile((File)file, (String)string);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public ToolType.Configfiles.Configfile saveAsConfigfile() {
        ToolType.Configfiles.Configfile configfile = ToolType.Configfiles.Configfile.Factory.newInstance();
        configfile.setName(this.name);
        configfile.setStringValue(this.content);
        return configfile;
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getConfigFileAbsPath() {
        return this.configFileAbsPath;
    }

    public String getWorkingDirectoryPath() {
        return this.workingDirectoryPath;
    }

    public void setWorkingDirectoryPath(String workingDirectoryPath) {
        this.workingDirectoryPath = workingDirectoryPath;
    }
}

