/*
 * Decompiled with CFR 0.152.
 */
package com.sixthhosp.gcmpa.tools.misc;

import com.sixthhosp.gcmpa.tools.misc.ConfigureFile;
import com.sixthhosp.gcmpa.xmlbeans.tool.ToolType;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.xmlbeans.XmlObject;

public class ConfigureFiles {
    private ArrayList<ConfigureFile> configureFilesArrayList = new ArrayList();
    private String workingDirectoryPath;

    public ConfigureFiles() {
    }

    public ConfigureFiles(ToolType.Configfiles configfiles, String workingDirectoryPath) {
        this();
        this.workingDirectoryPath = workingDirectoryPath;
        if (configfiles != null) {
            ToolType.Configfiles.Configfile[] configs;
            ToolType.Configfiles.Configfile[] configfileArray = configs = configfiles.getConfigfileArray();
            int n = configs.length;
            int n2 = 0;
            while (n2 < n) {
                ToolType.Configfiles.Configfile config = configfileArray[n2];
                this.configureFilesArrayList.add(new ConfigureFile(config, this.workingDirectoryPath));
                ++n2;
            }
        }
    }

    public void generateConfigFiles(HashMap<String, Object> dataModel) {
        for (ConfigureFile configureFile : this.configureFilesArrayList) {
            configureFile.generateConfigFile(dataModel);
        }
    }

    public HashMap<String, Object> updateDataModel(HashMap<String, Object> dataModel) {
        for (ConfigureFile configureFile : this.configureFilesArrayList) {
            dataModel.put(configureFile.getName(), configureFile.getConfigFileAbsPath());
        }
        return dataModel;
    }

    public void add(ConfigureFile configureFile) {
        this.configureFilesArrayList.add(configureFile);
    }

    public ToolType.Configfiles saveAsConfigfiles() {
        ToolType.Configfiles configfiles = ToolType.Configfiles.Factory.newInstance();
        for (ConfigureFile file : this.configureFilesArrayList) {
            configfiles.addNewConfigfile().set((XmlObject)file.saveAsConfigfile());
        }
        return configfiles;
    }

    public ArrayList<ConfigureFile> getConfigureFilesArrayList() {
        return this.configureFilesArrayList;
    }

    public void setConfigureFilesArrayList(ArrayList<ConfigureFile> configureFilesArrayList) {
        this.configureFilesArrayList = configureFilesArrayList;
    }

    public String getWorkingDirectoryPath() {
        return this.workingDirectoryPath;
    }

    public void setWorkingDirectoryPath(String workingDirectoryPath) {
        this.workingDirectoryPath = workingDirectoryPath;
    }
}

