/*
 * Decompiled with CFR 0.152.
 */
package com.sixthhosp.gcmpa.tools.parameters;

import com.sixthhosp.gcmpa.tools.parameters.ToolParameter;
import com.sixthhosp.gcmpa.tools.parameters.validators.ParameterValidateException;
import com.sixthhosp.gcmpa.tools.parameters.widgets.BooleanWidget;
import com.sixthhosp.gcmpa.xmlbeans.tool.ParamType;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class BooleanToolParameter
extends ToolParameter {
    private boolean checked;
    private String truevalue;
    private String falsevalue;
    private BooleanWidget booleanWidget;

    public BooleanToolParameter(ParamType paramType) {
        super(paramType);
        this.setChecked(Boolean.parseBoolean(paramType.getChecked()));
        this.setTruevalue(paramType.getTruevalue());
        this.setFalsevalue(paramType.getFalsevalue());
    }

    public String toString() {
        return "BooleanToolParameter";
    }

    @Override
    protected void creatParamWidget() {
        Composite composite = this.getPrimaryComposite();
        this.booleanWidget = new BooleanWidget(composite, this.checked);
    }

    @Override
    public Control getParamWidgetPrimaryControl() {
        return this.booleanWidget.getControl();
    }

    @Override
    public String getInputString() {
        if (this.booleanWidget != null && !this.booleanWidget.getCheckButton().isDisposed()) {
            if (this.booleanWidget.isSelected()) {
                return this.truevalue;
            }
            return this.falsevalue;
        }
        if (this.checked) {
            return this.truevalue;
        }
        return this.falsevalue;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public void validate() throws ParameterValidateException {
    }

    @Override
    public void doSave() {
        this.saveDataModel();
        if (this.booleanWidget != null && !this.booleanWidget.getCheckButton().isDisposed()) {
            this.checked = this.booleanWidget.isSelected();
        }
    }

    @Override
    public ParamType saveAsParamType() {
        ParamType newParamType = super.saveAsParamType();
        newParamType.setChecked(String.valueOf(this.checked));
        newParamType.setTruevalue(this.truevalue);
        newParamType.setFalsevalue(this.falsevalue);
        return newParamType;
    }

    public boolean isChecked() {
        return this.checked;
    }

    public void setChecked(boolean checked) {
        this.checked = checked;
    }

    public String getTruevalue() {
        return this.truevalue;
    }

    public void setTruevalue(String truevalue) {
        this.truevalue = truevalue;
    }

    public String getFalsevalue() {
        return this.falsevalue;
    }

    public void setFalsevalue(String falsevalue) {
        this.falsevalue = falsevalue;
    }

    @Override
    public boolean validateSavedValue() {
        return true;
    }

    @Override
    public void addValidatingEvent() {
    }
}

