/*
 * Decompiled with CFR 0.152.
 */
package com.sixthhosp.gcmpa.tools.parameters;

import com.sixthhosp.gcmpa.tools.parameters.ToolParameter;
import com.sixthhosp.gcmpa.tools.parameters.validators.ParameterValidateException;
import com.sixthhosp.gcmpa.tools.parameters.widgets.FileChooseWidget;
import com.sixthhosp.gcmpa.tools.parameters.widgets.InputValueChangeListener;
import com.sixthhosp.gcmpa.xmlbeans.tool.ParamType;
import java.io.File;
import java.util.ArrayList;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;

public class DataToolParameter
extends ToolParameter {
    private String format;
    private String id;
    private String outputName;
    private String fileAbsPath;
    private boolean workflowModel;
    private boolean multiple;
    private FileChooseWidget fileChooseWidget;
    private Label workflowDataLabel;

    public DataToolParameter(ParamType paramType) {
        super(paramType);
        this.setFormat(paramType.getFormat());
        this.setId(paramType.getId());
        this.setOutputName(paramType.getLastoutname());
        this.multiple = Boolean.parseBoolean(paramType.getMultiple());
        this.fileAbsPath = paramType.getPath();
        if (StringUtils.isBlank((String)this.fileAbsPath)) {
            this.fileAbsPath = "";
        }
        this.workflowModel = false;
    }

    public String toString() {
        return "DataToolParameter";
    }

    @Override
    protected void creatParamWidget() {
        if (!this.workflowModel) {
            String ext;
            Composite composite = this.getPrimaryComposite();
            String[] exts = this.format.split(",");
            ArrayList<String> newExts = new ArrayList<String>();
            String[] stringArray = exts;
            int n = exts.length;
            int n2 = 0;
            while (n2 < n) {
                ext = stringArray[n2];
                String e = "*." + ext;
                newExts.add(e);
                ++n2;
            }
            ext = StringUtils.join(newExts, (String)";");
            String[] filterExts = new String[]{ext, "*.*"};
            this.fileChooseWidget = new FileChooseWidget(composite, this.multiple, filterExts);
            this.fileChooseWidget.setWidgetBackgroudColor(composite.getDisplay().getSystemColor(1));
            if (!this.multiple) {
                if (StringUtils.isNotBlank((String)this.fileAbsPath) && new File(this.fileAbsPath).exists()) {
                    this.fileChooseWidget.setDefaultFile(new File(this.fileAbsPath));
                } else {
                    this.fileAbsPath = "";
                }
            } else if (StringUtils.isNotBlank((String)this.fileAbsPath)) {
                String[] files = StringUtils.splitByWholeSeparator((String)this.fileAbsPath, (String)FileChooseWidget.SEP);
                boolean isMissing = false;
                ArrayList<String> list = new ArrayList<String>();
                String[] stringArray2 = files;
                int n3 = files.length;
                int n4 = 0;
                while (n4 < n3) {
                    String file = stringArray2[n4];
                    File f = new File(file);
                    list.add(f.getName());
                    if (!f.exists()) {
                        isMissing = true;
                    }
                    ++n4;
                }
                if (isMissing) {
                    this.fileAbsPath = "";
                } else {
                    this.fileChooseWidget.setPath(this.fileAbsPath);
                    this.fileChooseWidget.setDefaultText(StringUtils.join(list, (String)" | "));
                }
            } else {
                this.fileAbsPath = "";
            }
            Control control = this.fileChooseWidget.getControl();
            control.addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseDown(MouseEvent e) {
                    DataToolParameter.this.getTopComposite().setFocus();
                }
            });
        } else {
            Composite composite = this.getPrimaryComposite();
            this.workflowDataLabel = new Label(composite, 0);
            String string = null;
            if (StringUtils.isBlank((String)this.fileAbsPath)) {
                string = "There is no data input provided ( " + this.format + " )";
            } else {
                String basename = FilenameUtils.getName((String)this.fileAbsPath);
                string = "Data input \"" + basename + "\"" + " ( " + this.format + " )";
            }
            this.workflowDataLabel.setText(string);
            this.workflowDataLabel.addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseDown(MouseEvent e) {
                    DataToolParameter.this.getTopComposite().setFocus();
                }
            });
        }
    }

    public void registerLabelDataWidget() {
        this.setWorkflowModel(true);
    }

    @Override
    public Control getParamWidgetPrimaryControl() {
        if (!this.workflowModel) {
            return this.fileChooseWidget.getControl();
        }
        return this.workflowDataLabel;
    }

    @Override
    public String getInputString() {
        if (!this.workflowModel) {
            if (this.fileChooseWidget.isEmpty()) {
                return "";
            }
            return this.fileChooseWidget.getAbsolutePath();
        }
        if (StringUtils.isBlank((String)this.fileAbsPath)) {
            return "";
        }
        return new File(this.fileAbsPath).getAbsolutePath();
    }

    @Override
    public boolean isEmpty() {
        if (this.fileChooseWidget != null && !this.fileChooseWidget.getControl().isDisposed()) {
            return this.fileChooseWidget.isEmpty();
        }
        return StringUtils.isBlank((String)this.fileAbsPath);
    }

    @Override
    public void validate() throws ParameterValidateException {
        if (!this.isOptional() && this.isEmpty()) {
            if (!this.multiple) {
                throw new ParameterValidateException("A input file is required");
            }
            throw new ParameterValidateException("Some input files are required");
        }
    }

    @Override
    public boolean validateSavedValue() {
        return this.isOptional() || !StringUtils.isBlank((String)this.fileAbsPath);
    }

    public void clearSavedVaule() {
        this.id = null;
        this.outputName = null;
        this.fileAbsPath = "";
    }

    @Override
    public void doSave() {
        this.saveDataModel();
        if (!this.workflowModel) {
            this.fileAbsPath = this.getInputString();
        }
    }

    @Override
    public ParamType saveAsParamType() {
        ParamType newParamType = super.saveAsParamType();
        newParamType.setFormat(this.format);
        newParamType.setMultiple(String.valueOf(this.multiple));
        if (this.isWorkflowModel()) {
            if (StringUtils.isNotBlank((String)this.id)) {
                newParamType.setId(this.id);
            }
            if (StringUtils.isNotBlank((String)this.outputName)) {
                newParamType.setLastoutname(this.outputName);
            }
        }
        if (StringUtils.isNotBlank((String)this.fileAbsPath)) {
            newParamType.setPath(this.fileAbsPath);
        }
        return newParamType;
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public String getFileAbsPath() {
        return this.fileAbsPath;
    }

    public void setFileAbsPath(String fileAbsPath) {
        this.fileAbsPath = fileAbsPath;
    }

    public boolean isWorkflowModel() {
        return this.workflowModel;
    }

    public void setWorkflowModel(boolean workflowModel) {
        this.workflowModel = workflowModel;
    }

    public Label getWorkflowDataLabel() {
        return this.workflowDataLabel;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getOutputName() {
        return this.outputName;
    }

    public void setOutputName(String outputName) {
        this.outputName = outputName;
    }

    @Override
    public void addValidatingEvent() {
        if (!this.workflowModel) {
            this.fileChooseWidget.addInputValueChangeListener(new InputValueChangeListener(){

                @Override
                public void InputValueChangeEvent() {
                    DataToolParameter.this.startValidating();
                }
            });
        }
    }
}

