/*
 * Decompiled with CFR 0.152.
 */
package com.sixthhosp.gcmpa.tools.parameters;

import com.sixthhosp.gcmpa.tools.parameters.TextToolParameter;
import com.sixthhosp.gcmpa.tools.parameters.validators.ParameterValidateException;
import com.sixthhosp.gcmpa.tools.parameters.validators.Validator;
import com.sixthhosp.gcmpa.xmlbeans.tool.ParamType;
import java.math.BigDecimal;

public class FloatToolParameter
extends TextToolParameter {
    public FloatToolParameter(ParamType paramType) {
        super(paramType);
    }

    @Override
    public String toString() {
        return "FloatToolParameter";
    }

    @Override
    public void validate() throws ParameterValidateException {
        if (!this.isOptional() && this.isEmpty()) {
            throw new ParameterValidateException("A input value is required.");
        }
        try {
            String input = this.getInputString();
            new BigDecimal(input);
        }
        catch (NumberFormatException numberFormatException) {
            throw new ParameterValidateException("A real number is required.");
        }
        this.checkValidators();
    }

    @Override
    public boolean validateSavedValue() {
        boolean b = true;
        try {
            if (!this.isOptional() && this.getValue().equals("")) {
                throw new ParameterValidateException("A input value is required");
            }
            try {
                String input = this.getValue();
                new BigDecimal(input);
            }
            catch (NumberFormatException numberFormatException) {
                throw new ParameterValidateException("A real number is required.");
            }
            for (Validator validator : this.getValidators()) {
                String msg = validator.validate(this.getValue());
                if (msg == null) continue;
                throw new ParameterValidateException(msg);
            }
        }
        catch (ParameterValidateException parameterValidateException) {
            b = false;
        }
        return b;
    }
}

