/*
 * Decompiled with CFR 0.152.
 */
package com.sixthhosp.gcmpa.tools.parameters;

import com.sixthhosp.gcmpa.tools.parameters.TextToolParameter;
import com.sixthhosp.gcmpa.tools.parameters.validators.ParameterValidateException;
import com.sixthhosp.gcmpa.tools.parameters.validators.Validator;
import com.sixthhosp.gcmpa.xmlbeans.tool.ParamType;
import java.math.BigInteger;

public class IntegerToolParameter
extends TextToolParameter {
    public IntegerToolParameter(ParamType paramType) {
        super(paramType);
    }

    @Override
    public String toString() {
        return "IntegerToolParameter";
    }

    @Override
    public void validate() throws ParameterValidateException {
        if (!this.isOptional() && this.isEmpty()) {
            throw new ParameterValidateException("A input value is required.");
        }
        try {
            String input = this.getInputString();
            new BigInteger(input);
        }
        catch (NumberFormatException numberFormatException) {
            throw new ParameterValidateException("An integer is required.");
        }
        this.checkValidators();
    }

    @Override
    public boolean validateSavedValue() {
        boolean b = true;
        try {
            if (!this.isOptional() && this.getValue().equals("")) {
                throw new ParameterValidateException("A input value is required");
            }
            try {
                String input = this.getValue();
                new BigInteger(input);
            }
            catch (NumberFormatException numberFormatException) {
                throw new ParameterValidateException("An integer is required.");
            }
            for (Validator validator : this.getValidators()) {
                String msg = validator.validate(this.getValue());
                if (msg == null) continue;
                throw new ParameterValidateException(msg);
            }
        }
        catch (ParameterValidateException parameterValidateException) {
            b = false;
        }
        return b;
    }
}

