/*
 * Decompiled with CFR 0.152.
 */
package com.sixthhosp.gcmpa.tools.parameters;

import com.sixthhosp.gcmpa.configs.ConfigFile;
import com.sixthhosp.gcmpa.tools.parameters.Option;
import com.sixthhosp.gcmpa.tools.parameters.ToolParameter;
import com.sixthhosp.gcmpa.tools.parameters.validators.ParameterValidateException;
import com.sixthhosp.gcmpa.tools.parameters.widgets.CheckBoxGroup;
import com.sixthhosp.gcmpa.tools.parameters.widgets.InputValueChangeListener;
import com.sixthhosp.gcmpa.tools.parameters.widgets.ObjectWithStat;
import com.sixthhosp.gcmpa.tools.parameters.widgets.RadioGroup;
import com.sixthhosp.gcmpa.tools.parameters.widgets.SelectionWidget;
import com.sixthhosp.gcmpa.xmlbeans.tool.OptionType;
import com.sixthhosp.gcmpa.xmlbeans.tool.ParamType;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class SelectToolParameter
extends ToolParameter {
    private ParamType.Display.Enum display;
    private boolean multiple;
    private String separator;
    private Option[] options;
    private SelectionWidget selectionWidget;

    public SelectToolParameter(ParamType paramType) {
        super(paramType);
        this.setDisplay(paramType.getDisplay());
        this.setMultiple(Boolean.parseBoolean(paramType.getMultiple()));
        this.setSeparator(paramType.getSeparator());
        if (!paramType.isSetOptional()) {
            if (this.display == ParamType.Display.DEFAULT && this.multiple) {
                this.setOptional(true);
            } else if (this.display == ParamType.Display.CHECKBOXES) {
                this.setOptional(true);
            }
        }
        if (paramType.isSetOptions()) {
            ParamType.Options opts = paramType.getOptions();
            this.options = SelectToolParameter.readOptionsFromLocFile(opts);
        } else {
            OptionType[] optionTypes = paramType.getOptionArray();
            this.options = new Option[optionTypes.length];
            int i = 0;
            while (i < this.options.length) {
                this.options[i] = new Option(optionTypes[i]);
                ++i;
            }
        }
        boolean isEmpty = true;
        Option[] optionArray = this.options;
        int n = this.options.length;
        int n2 = 0;
        while (n2 < n) {
            Option option = optionArray[n2];
            if (option.isSelected()) {
                isEmpty = false;
            }
            ++n2;
        }
        if ((this.display == ParamType.Display.DEFAULT && !this.multiple || this.display == ParamType.Display.RADIO) && isEmpty) {
            this.options[0].setSelected(true);
        }
    }

    public String toString() {
        return "SelectToolParameter";
    }

    @Override
    protected void creatParamWidget() {
        Composite composite = this.getPrimaryComposite();
        this.selectionWidget = SelectionWidget.init(composite, this.display, this.multiple, this.getName());
        this.selectionWidget.setInput(this.options);
        this.selectionWidget.setWidgetBackgroudColor(composite.getDisplay().getSystemColor(1));
        if (this.selectionWidget instanceof CheckBoxGroup) {
            CheckBoxGroup checkBoxGroup = (CheckBoxGroup)this.selectionWidget;
            Control control = checkBoxGroup.getControl();
            Composite group = checkBoxGroup.getGroup();
            control.addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseDown(MouseEvent e) {
                    SelectToolParameter.this.getTopComposite().setFocus();
                }
            });
            group.addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseDown(MouseEvent e) {
                    SelectToolParameter.this.getTopComposite().setFocus();
                }
            });
        } else if (this.selectionWidget instanceof RadioGroup) {
            RadioGroup radioGroup = (RadioGroup)this.selectionWidget;
            Composite group = radioGroup.getGroup();
            group.addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseDown(MouseEvent e) {
                    SelectToolParameter.this.getTopComposite().setFocus();
                }
            });
        }
    }

    @Override
    public Control getParamWidgetPrimaryControl() {
        return this.selectionWidget.getControl();
    }

    @Override
    public String getInputString() {
        if (this.selectionWidget != null && !this.selectionWidget.getControl().isDisposed()) {
            if (this.selectionWidget.isEmpty()) {
                return "";
            }
            Object[] selectedObjects = this.selectionWidget.getSelection();
            ArrayList<String> list = new ArrayList<String>();
            Object[] objectArray = selectedObjects;
            int n = selectedObjects.length;
            int n2 = 0;
            while (n2 < n) {
                Object object = objectArray[n2];
                Option option = (Option)object;
                list.add(option.getValue());
                ++n2;
            }
            Object[] strings = list.toArray(new String[list.size()]);
            return StringUtils.join((Object[])strings, (String)this.separator);
        }
        ArrayList<String> list = new ArrayList<String>();
        Option[] optionArray = this.options;
        int n = this.options.length;
        int n3 = 0;
        while (n3 < n) {
            Option option = optionArray[n3];
            if (option.isSelected()) {
                list.add(option.getValue());
            }
            ++n3;
        }
        if (this.display == ParamType.Display.DEFAULT && !this.multiple || this.display == ParamType.Display.RADIO) {
            if (list.size() == 0) {
                list.add(this.options[0].getValue());
            } else if (list.size() > 1) {
                String string = (String)list.get(list.size() - 1);
                list = new ArrayList();
                list.add(string);
            }
        }
        Object[] strings = list.toArray(new String[list.size()]);
        return StringUtils.join((Object[])strings, (String)this.separator);
    }

    @Override
    public boolean isEmpty() {
        return this.selectionWidget.isEmpty();
    }

    @Override
    public void validate() throws ParameterValidateException {
        if (!this.isOptional() && this.isEmpty()) {
            throw new ParameterValidateException("No option was selected, but input is not optional.");
        }
    }

    @Override
    public boolean validateSavedValue() {
        boolean isEmpty = true;
        Option[] optionArray = this.options;
        int n = this.options.length;
        int n2 = 0;
        while (n2 < n) {
            Option option = optionArray[n2];
            if (option.isSelected()) {
                isEmpty = false;
            }
            ++n2;
        }
        return this.isOptional() || !isEmpty;
    }

    @Override
    public void addValidatingEvent() {
        this.selectionWidget.addInputValueChangeListener(new InputValueChangeListener(){

            @Override
            public void InputValueChangeEvent() {
                SelectToolParameter.this.startValidating();
            }
        });
    }

    @Override
    public void doSave() {
        this.saveDataModel();
        if (this.selectionWidget != null && !this.selectionWidget.getControl().isDisposed()) {
            ArrayList<ObjectWithStat> list = this.selectionWidget.getObjectsWithSelectionStat();
            ArrayList<Option> optionsList = new ArrayList<Option>();
            for (ObjectWithStat object : list) {
                Option option = (Option)object.getObject();
                option.setSelected(object.isSelected());
                optionsList.add(option);
            }
            this.options = optionsList.toArray(new Option[optionsList.size()]);
        }
    }

    @Override
    public ParamType saveAsParamType() {
        ParamType newParamType = super.saveAsParamType();
        newParamType.setDisplay(this.display);
        newParamType.setMultiple(String.valueOf(this.multiple));
        newParamType.setSeparator(this.separator);
        OptionType[] optionTypes = new OptionType[this.options.length];
        int i = 0;
        while (i < this.options.length) {
            optionTypes[i] = OptionType.Factory.newInstance();
            optionTypes[i].setSelected(String.valueOf(this.options[i].isSelected()));
            optionTypes[i].setValue(this.options[i].getValue());
            optionTypes[i].setStringValue(this.options[i].getText());
            ++i;
        }
        newParamType.setOptionArray(optionTypes);
        return newParamType;
    }

    public ParamType.Display.Enum getDisplay() {
        return this.display;
    }

    public void setDisplay(ParamType.Display.Enum display) {
        this.display = display;
    }

    public boolean isMultiple() {
        return this.multiple;
    }

    public void setMultiple(boolean multiple) {
        this.multiple = multiple;
    }

    public String getSeparator() {
        return this.separator;
    }

    public void setSeparator(String separator) {
        this.separator = separator;
    }

    public static Option[] readOptionsFromLocFile(ParamType.Options options) {
        ArrayList<Option> list = new ArrayList<Option>();
        String rel_file = options.getFromFile();
        String abs_file = String.valueOf(ConfigFile.getLocFolderPath()) + "/" + rel_file;
        int value_col = options.getValueCol();
        int text_col = options.getDisplayCol();
        File file = new File(abs_file);
        try {
            BufferedReader reader = new BufferedReader(new FileReader(file));
            String line = null;
            while ((line = reader.readLine()) != null) {
                if (line.startsWith("#")) continue;
                String[] strings = line.split("\t");
                Option option = new Option(strings[text_col - 1], strings[value_col - 1], false);
                list.add(option);
            }
            reader.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ArrayIndexOutOfBoundsException e) {
            e.printStackTrace();
        }
        return list.toArray(new Option[list.size()]);
    }
}

