/*
 * Decompiled with CFR 0.152.
 */
package com.sixthhosp.gcmpa.tools.parameters;

import com.sixthhosp.gcmpa.tools.parameters.ToolParameter;
import com.sixthhosp.gcmpa.tools.parameters.validators.ParameterValidateException;
import com.sixthhosp.gcmpa.tools.parameters.validators.Validator;
import com.sixthhosp.gcmpa.tools.parameters.widgets.InputValueChangeListener;
import com.sixthhosp.gcmpa.tools.parameters.widgets.TextWidget;
import com.sixthhosp.gcmpa.xmlbeans.tool.ParamType;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class TextToolParameter
extends ToolParameter {
    private boolean area;
    private String size;
    private String value;
    private TextWidget textWidget;

    public TextToolParameter(ParamType paramType) {
        super(paramType);
        this.setArea(Boolean.parseBoolean(paramType.getArea()));
        this.setSize(paramType.getSize());
        this.setValue(paramType.getValue());
        if (this.value == null) {
            this.value = "";
        }
        if (this.area && !paramType.isSetSize()) {
            this.size = "5x50";
        }
    }

    public String toString() {
        return "TextToolParameter";
    }

    @Override
    protected void creatParamWidget() {
        Composite composite = this.getPrimaryComposite();
        this.textWidget = new TextWidget(composite, this.value, this.size, this.area);
        this.textWidget.setWidgetBackgroudColor(composite.getDisplay().getSystemColor(1));
    }

    @Override
    public Control getParamWidgetPrimaryControl() {
        return this.textWidget.getControl();
    }

    @Override
    public String getInputString() {
        if (this.textWidget != null && !this.textWidget.getText().isDisposed()) {
            if (this.textWidget.isEmpty()) {
                return "";
            }
            return this.textWidget.getInputString();
        }
        return this.value;
    }

    @Override
    public boolean isEmpty() {
        return this.textWidget.isEmpty();
    }

    @Override
    public void validate() throws ParameterValidateException {
        if (!this.isOptional() && this.isEmpty()) {
            throw new ParameterValidateException("A input value is required");
        }
        this.checkValidators();
    }

    @Override
    public boolean validateSavedValue() {
        boolean b = true;
        try {
            if (!this.isOptional() && this.value.equals("")) {
                throw new ParameterValidateException("A input value is required");
            }
            for (Validator validator : this.getValidators()) {
                String msg = validator.validate(this.value);
                if (msg == null) continue;
                throw new ParameterValidateException(msg);
            }
        }
        catch (ParameterValidateException parameterValidateException) {
            b = false;
        }
        return b;
    }

    @Override
    public void doSave() {
        this.saveDataModel();
        if (this.textWidget != null && !this.textWidget.getText().isDisposed()) {
            this.value = this.textWidget.getInputString();
        }
    }

    @Override
    public ParamType saveAsParamType() {
        ParamType newParamType = super.saveAsParamType();
        newParamType.setArea(String.valueOf(this.area));
        newParamType.setSize(this.size);
        newParamType.setValue(this.value);
        return newParamType;
    }

    public boolean isArea() {
        return this.area;
    }

    public void setArea(boolean area) {
        this.area = area;
    }

    public String getSize() {
        return this.size;
    }

    public void setSize(String size) {
        this.size = size;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    @Override
    public void addValidatingEvent() {
        this.textWidget.addInputValueChangeListener(new InputValueChangeListener(){

            @Override
            public void InputValueChangeEvent() {
                TextToolParameter.this.startValidating();
            }
        });
    }
}

