/*
 * Decompiled with CFR 0.152.
 */
package com.sixthhosp.gcmpa.tools.parameters;

import com.sixthhosp.gcmpa.tools.Utils;
import com.sixthhosp.gcmpa.tools.parameters.BooleanToolParameter;
import com.sixthhosp.gcmpa.tools.parameters.DataToolParameter;
import com.sixthhosp.gcmpa.tools.parameters.FloatToolParameter;
import com.sixthhosp.gcmpa.tools.parameters.HiddenToolParameter;
import com.sixthhosp.gcmpa.tools.parameters.IntegerToolParameter;
import com.sixthhosp.gcmpa.tools.parameters.SelectToolParameter;
import com.sixthhosp.gcmpa.tools.parameters.TextToolParameter;
import com.sixthhosp.gcmpa.tools.parameters.validators.ParameterValidateException;
import com.sixthhosp.gcmpa.tools.parameters.validators.Validator;
import com.sixthhosp.gcmpa.xmlbeans.tool.ParamType;
import com.sixthhosp.gcmpa.xmlbeans.tool.TypeType;
import com.sixthhosp.gcmpa.xmlbeans.tool.ValidatorType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.text.WordUtils;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public abstract class ToolParameter {
    private String name;
    private TypeType.Enum type;
    private String label;
    private String help;
    private boolean optional;
    private ValidatorType[] validatorTypes;
    private boolean isAlwaysValidate;
    private List<Validator> validators = new ArrayList<Validator>();
    private boolean HelpExist;
    private HashMap<String, String> dataModelMap;
    private Composite topComposite;
    protected Composite composite;
    private Label labelWidget;
    private CLabel errorTip;
    private Label helpWidget;
    private Label separatorLine;

    public ToolParameter() {
    }

    public ToolParameter(ParamType paramType) {
        this();
        this.setName(paramType.getName());
        this.setType(paramType.getType());
        this.setLabel(paramType.getLabel());
        this.setHelp(paramType.getHelp());
        this.setOptional(Boolean.parseBoolean(paramType.getOptional()));
        if (StringUtils.isBlank((String)this.label)) {
            this.label = this.name;
        }
        if (StringUtils.isBlank((String)this.help)) {
            this.help = "";
            this.setHelpExist(false);
        } else {
            this.setHelpExist(true);
        }
        ValidatorType[] validatorTypeArray = this.validatorTypes = paramType.getValidatorArray();
        int n = this.validatorTypes.length;
        int n2 = 0;
        while (n2 < n) {
            ValidatorType validatorType = validatorTypeArray[n2];
            Validator validator = Validator.init(validatorType);
            this.validators.add(validator);
            ++n2;
        }
        this.isAlwaysValidate = false;
    }

    public void creatContents(Composite parent, Composite topComposite) {
        FontData[] fontDatas;
        this.setTopComposite(topComposite);
        this.composite = new Composite(parent, 0);
        this.composite.setBackground(this.composite.getDisplay().getSystemColor(1));
        GridData compositeGridData = new GridData(768);
        compositeGridData.verticalIndent = -5;
        this.composite.setLayoutData((Object)compositeGridData);
        this.composite.setLayout((Layout)new GridLayout(1, false));
        FontData[] fontDataArray = fontDatas = Display.getCurrent().getSystemFont().getFontData();
        int n = fontDatas.length;
        int n2 = 0;
        while (n2 < n) {
            FontData fontData = fontDataArray[n2];
            fontData.setStyle(1);
            ++n2;
        }
        Font font = new Font((Device)Display.getCurrent(), fontDatas);
        this.labelWidget = new Label(this.composite, 0);
        this.labelWidget.setBackground(this.labelWidget.getDisplay().getSystemColor(1));
        String labelText = String.valueOf(this.label);
        labelText = WordUtils.wrap((String)labelText, (int)100);
        this.labelWidget.setText(labelText);
        this.labelWidget.setFont(font);
        this.creatParamWidget();
        if (this.isHelpExist()) {
            this.helpWidget = new Label(this.composite, 0);
            this.helpWidget.setBackground(this.helpWidget.getDisplay().getSystemColor(1));
            String helpText = this.help;
            helpText = WordUtils.wrap((String)helpText, (int)100);
            this.helpWidget.setText(helpText);
            Color color = Display.getCurrent().getSystemColor(16);
            this.helpWidget.setForeground(color);
        }
        this.separatorLine = new Label(this.composite, 258);
        GridData gridData = new GridData(768);
        this.separatorLine.setLayoutData((Object)gridData);
        font.dispose();
        this.addMouseDownFoucusEvent();
        if (this.isAlwaysValidate) {
            this.startValidating();
            this.addValidatingEvent();
        }
    }

    protected void addMouseDownFoucusEvent() {
        this.composite.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                ToolParameter.this.topComposite.setFocus();
            }
        });
        this.labelWidget.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                ToolParameter.this.topComposite.setFocus();
            }
        });
        if (this.isHelpExist()) {
            this.helpWidget.addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseDown(MouseEvent e) {
                    ToolParameter.this.topComposite.setFocus();
                }
            });
        }
        this.separatorLine.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                ToolParameter.this.topComposite.setFocus();
            }
        });
    }

    public void registerAlwaysValidating() {
        if (this.composite != null && !this.composite.isDisposed() && !this.isAlwaysValidate) {
            this.addValidatingEvent();
        }
        this.isAlwaysValidate = true;
    }

    public abstract void addValidatingEvent();

    protected abstract void creatParamWidget();

    public abstract Control getParamWidgetPrimaryControl();

    public abstract String getInputString();

    public abstract boolean isEmpty();

    public boolean startValidating() {
        boolean b = true;
        boolean isNeedRefresh = false;
        if (this.errorTip != null && !this.errorTip.isDisposed()) {
            this.errorTip.dispose();
            isNeedRefresh = true;
        }
        try {
            this.validate();
        }
        catch (ParameterValidateException e) {
            b = false;
            String msg = e.getMessage();
            this.errorTip = new CLabel(this.composite, 16384);
            this.errorTip.setBackground(this.errorTip.getDisplay().getSystemColor(1));
            ImageData errorImageData = Display.getCurrent().getSystemImage(1).getImageData().scaledTo(16, 16);
            final Image errorImage = ImageDescriptor.createFromImageData((ImageData)errorImageData).createImage();
            this.errorTip.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    errorImage.dispose();
                }
            });
            this.errorTip.setImage(errorImage);
            this.errorTip.setText(msg);
            this.errorTip.setForeground(Display.getCurrent().getSystemColor(3));
            this.errorTip.moveBelow(this.getParamWidgetPrimaryControl());
            isNeedRefresh = true;
            this.errorTip.addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseDown(MouseEvent e) {
                    ToolParameter.this.topComposite.setFocus();
                }
            });
        }
        if (isNeedRefresh) {
            this.topComposite.layout(new Control[]{this.labelWidget});
            Utils.reSize(this.topComposite);
        }
        return b;
    }

    public abstract void validate() throws ParameterValidateException;

    public void checkValidators() throws ParameterValidateException {
        for (Validator validator : this.validators) {
            String msg = validator.validate(this.getInputString());
            if (msg == null) continue;
            throw new ParameterValidateException(msg);
        }
    }

    public abstract void doSave();

    public ParamType saveAsParamType() {
        ParamType newParamType = ParamType.Factory.newInstance();
        newParamType.setName(this.name);
        newParamType.setType(this.type);
        newParamType.setLabel(this.label);
        newParamType.setHelp(this.help);
        newParamType.setOptional(String.valueOf(this.optional));
        newParamType.setValidatorArray(this.validatorTypes);
        return newParamType;
    }

    public void saveDataModel() {
        String key = this.getName();
        String value = this.getInputString();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(key, value);
        this.dataModelMap = map;
    }

    public abstract boolean validateSavedValue();

    public HashMap<String, String> getDataModelMap() {
        return this.dataModelMap;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public TypeType.Enum getType() {
        return this.type;
    }

    public void setType(TypeType.Enum type) {
        this.type = type;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getHelp() {
        return this.help;
    }

    public void setHelp(String help) {
        this.help = help;
    }

    public boolean isOptional() {
        return this.optional;
    }

    public void setOptional(boolean optional) {
        this.optional = optional;
    }

    public ValidatorType[] getValidatorTypes() {
        return this.validatorTypes;
    }

    public void setValidatorTypes(ValidatorType[] validatorTypes) {
        this.validatorTypes = validatorTypes;
    }

    public List<Validator> getValidators() {
        return this.validators;
    }

    public void setValidators(List<Validator> validators) {
        this.validators = validators;
    }

    public boolean isHelpExist() {
        return this.HelpExist;
    }

    public void setHelpExist(boolean helpExist) {
        this.HelpExist = helpExist;
    }

    public boolean isAlwaysValidate() {
        return this.isAlwaysValidate;
    }

    public void setAlwaysValidate(boolean isAlwaysValidate) {
        this.isAlwaysValidate = isAlwaysValidate;
    }

    public Label getLabelWidget() {
        return this.labelWidget;
    }

    public CLabel getErrorTip() {
        return this.errorTip;
    }

    public Label getHelpWidget() {
        return this.helpWidget;
    }

    public Label getSeparatorLine() {
        return this.separatorLine;
    }

    public void dispose() {
        this.composite.dispose();
    }

    public Composite getPrimaryComposite() {
        return this.composite;
    }

    public static ToolParameter init(ParamType paramType) {
        TypeType.Enum type = paramType.getType();
        if (type == TypeType.TEXT) {
            return new TextToolParameter(paramType);
        }
        if (type == TypeType.INTEGER) {
            return new IntegerToolParameter(paramType);
        }
        if (type == TypeType.FLOAT) {
            return new FloatToolParameter(paramType);
        }
        if (type == TypeType.DATA) {
            return new DataToolParameter(paramType);
        }
        if (type == TypeType.SELECT) {
            return new SelectToolParameter(paramType);
        }
        if (type == TypeType.BOOLEAN) {
            return new BooleanToolParameter(paramType);
        }
        if (type == TypeType.HIDDEN) {
            return new HiddenToolParameter(paramType);
        }
        return null;
    }

    public Composite getTopComposite() {
        return this.topComposite;
    }

    public void setTopComposite(Composite topComposite) {
        this.topComposite = topComposite;
    }
}

