/*
 * Decompiled with CFR 0.152.
 */
package com.sixthhosp.gcmpa.tools.parameters.validators;

import com.sixthhosp.gcmpa.tools.parameters.validators.Validator;
import com.sixthhosp.gcmpa.xmlbeans.tool.ValidatorType;
import java.math.BigDecimal;

public class InRangeValidator
extends Validator {
    private BigDecimal min;
    private BigDecimal max;

    public InRangeValidator(ValidatorType validatorType) {
        super(validatorType);
        this.setMin(validatorType.getMin());
        this.setMax(validatorType.getMax());
    }

    @Override
    public String validate(String input) {
        try {
            BigDecimal val = new BigDecimal(input);
            if (this.min != null && this.min.compareTo(val) > 0) {
                String messages = this.getMessage();
                if (messages != null) {
                    return messages;
                }
                return "Value must be greater than \"" + this.min + "\"";
            }
            if (this.max != null && this.max.compareTo(val) < 0) {
                String messages = this.getMessage();
                if (messages != null) {
                    return messages;
                }
                return "Value must be lower than \"" + this.max + "\"";
            }
        }
        catch (NumberFormatException numberFormatException) {}
        return null;
    }

    public String toString() {
        String string = "In Range Validator: min = " + this.getMin() + " max = " + this.getMax() + " message = " + this.getMessage();
        return string;
    }

    public BigDecimal getMin() {
        return this.min;
    }

    public void setMin(BigDecimal min) {
        this.min = min;
    }

    public BigDecimal getMax() {
        return this.max;
    }

    public void setMax(BigDecimal max) {
        this.max = max;
    }
}

