/*
 * Decompiled with CFR 0.152.
 */
package com.sixthhosp.gcmpa.tools.parameters.validators;

import com.sixthhosp.gcmpa.tools.parameters.validators.Validator;
import com.sixthhosp.gcmpa.xmlbeans.tool.ValidatorType;
import java.math.BigDecimal;

public class LengthValidator
extends Validator {
    private BigDecimal min;
    private BigDecimal max;

    public LengthValidator(ValidatorType validatorType) {
        super(validatorType);
        this.setMin(validatorType.getMin());
        this.setMax(validatorType.getMax());
    }

    @Override
    public String validate(String input) {
        BigDecimal length = new BigDecimal(input.length());
        if (this.min != null && this.min.compareTo(length) > 0) {
            String messages = this.getMessage();
            if (messages != null) {
                return messages;
            }
            return "String must have length of at least \"" + this.min + "\"";
        }
        if (this.max != null && this.max.compareTo(length) < 0) {
            String messages = this.getMessage();
            if (messages != null) {
                return messages;
            }
            return "String must have length no more than \"" + this.max + "\"";
        }
        return null;
    }

    public String toString() {
        String string = "Length Validator: min = " + this.getMin() + " max = " + this.getMax() + " message = " + this.getMessage();
        return string;
    }

    public BigDecimal getMin() {
        return this.min;
    }

    public void setMin(BigDecimal min) {
        this.min = min;
    }

    public BigDecimal getMax() {
        return this.max;
    }

    public void setMax(BigDecimal max) {
        this.max = max;
    }
}

