/*
 * Decompiled with CFR 0.152.
 */
package com.sixthhosp.gcmpa.tools.parameters.validators;

import com.sixthhosp.gcmpa.tools.parameters.validators.Validator;
import com.sixthhosp.gcmpa.xmlbeans.tool.ValidatorType;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RegexValidator
extends Validator {
    private String regex;

    public RegexValidator(ValidatorType validatorType) {
        super(validatorType);
        this.setRegex(validatorType.getStringValue());
    }

    @Override
    public String validate(String input) {
        if (this.regex != null) {
            Pattern pattern = Pattern.compile(this.regex);
            Matcher matcher = pattern.matcher(input);
            boolean b = matcher.matches();
            String messages = this.getMessage();
            if (!b) {
                if (messages != null) {
                    return messages;
                }
                return "String must match the regex \"" + this.regex + "\"";
            }
        }
        return null;
    }

    public String toString() {
        String string = "Regex Validator: regex = " + this.getRegex() + " message = " + this.getMessage();
        return string;
    }

    public String getRegex() {
        return this.regex;
    }

    public void setRegex(String regex) {
        this.regex = regex;
    }
}

