/*
 * Decompiled with CFR 0.152.
 */
package com.sixthhosp.gcmpa.tools.parameters.validators;

import com.sixthhosp.gcmpa.tools.parameters.validators.InRangeValidator;
import com.sixthhosp.gcmpa.tools.parameters.validators.LengthValidator;
import com.sixthhosp.gcmpa.tools.parameters.validators.RegexValidator;
import com.sixthhosp.gcmpa.xmlbeans.tool.ValidatorType;

public abstract class Validator {
    private ValidatorType.Type.Enum type;
    private String message;

    public Validator() {
    }

    public Validator(ValidatorType validatorType) {
        this.setType(validatorType.getType());
        this.setMessage(validatorType.getMessage());
    }

    public abstract String validate(String var1);

    public static Validator init(ValidatorType validatorType) {
        ValidatorType.Type.Enum type = validatorType.getType();
        if (type == ValidatorType.Type.IN_RANGE) {
            return new InRangeValidator(validatorType);
        }
        if (type == ValidatorType.Type.LENGTH) {
            return new LengthValidator(validatorType);
        }
        if (type == ValidatorType.Type.REGEX) {
            return new RegexValidator(validatorType);
        }
        return null;
    }

    public ValidatorType.Type.Enum getType() {
        return this.type;
    }

    public void setType(ValidatorType.Type.Enum type) {
        this.type = type;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }
}

