/*
 * Decompiled with CFR 0.152.
 */
package com.sixthhosp.gcmpa.tools.parameters.widgets;

import com.sixthhosp.gcmpa.tools.parameters.widgets.ISelectionTypeProvider;
import com.sixthhosp.gcmpa.tools.parameters.widgets.InputValueChangeListener;
import com.sixthhosp.gcmpa.tools.parameters.widgets.ObjectWithStat;
import com.sixthhosp.gcmpa.tools.parameters.widgets.SelectionWidget;
import java.util.ArrayList;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

public class CheckTableGroup
extends SelectionWidget {
    private Composite composite;
    private Table table;
    private TableItem[] tableItem;
    private Object[] objects;
    private ISelectionTypeProvider provider;

    public CheckTableGroup(Composite parent) {
        this.composite = new Composite(parent, 0);
        this.table = new Table(this.composite, 2848);
        this.table.setSize(350, 120);
        this.table.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (e.detail != 32) {
                    CheckTableGroup.this.table.deselectAll();
                }
            }
        });
    }

    @Override
    public void setInput(Object input) {
        this.objects = this.provider.getElements(input);
        this.tableItem = new TableItem[this.objects.length];
        int i = 0;
        while (i < this.objects.length) {
            this.tableItem[i] = new TableItem(this.table, 0);
            this.tableItem[i].setText(this.provider.getText(this.objects[i]));
            this.tableItem[i].setChecked(this.provider.getSelectionStat(this.objects[i]));
            ++i;
        }
    }

    @Override
    public Object[] getSelection() {
        ArrayList<Object> list = new ArrayList<Object>();
        int i = 0;
        while (i < this.objects.length) {
            if (this.tableItem[i].getChecked()) {
                list.add(this.objects[i]);
            }
            ++i;
        }
        return list.toArray();
    }

    @Override
    public ArrayList<ObjectWithStat> getObjectsWithSelectionStat() {
        ArrayList<ObjectWithStat> list = new ArrayList<ObjectWithStat>();
        int i = 0;
        while (i < this.objects.length) {
            if (this.tableItem[i].getChecked()) {
                list.add(new ObjectWithStat(this.objects[i], true));
            } else {
                list.add(new ObjectWithStat(this.objects[i], false));
            }
            ++i;
        }
        return list;
    }

    public Table getTable() {
        return this.table;
    }

    @Override
    public ISelectionTypeProvider getProvider() {
        return this.provider;
    }

    @Override
    public void setProvider(ISelectionTypeProvider provider) {
        this.provider = provider;
    }

    @Override
    public void dispose() {
        this.composite.dispose();
    }

    @Override
    public void setSize(int width, int height) {
        this.table.setSize(width, height);
    }

    @Override
    public Control getControl() {
        return this.composite;
    }

    @Override
    public void setWidgetBackgroudColor(Color color) {
        this.composite.setBackground(color);
        this.table.setBackground(color);
    }

    @Override
    public void addInputValueChangeListener(final InputValueChangeListener listener) {
        this.table.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (e.detail == 32) {
                    listener.InputValueChangeEvent();
                }
            }
        });
    }
}

