/*
 * Decompiled with CFR 0.152.
 */
package com.sixthhosp.gcmpa.tools.parameters.widgets;

import com.sixthhosp.gcmpa.tools.parameters.widgets.ISelectionTypeProvider;
import com.sixthhosp.gcmpa.tools.parameters.widgets.InputValueChangeListener;
import com.sixthhosp.gcmpa.tools.parameters.widgets.ObjectWithStat;
import com.sixthhosp.gcmpa.tools.parameters.widgets.SelectionWidget;
import java.util.ArrayList;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class ComboGroup
extends SelectionWidget {
    private Combo combo;
    private Object[] objects;
    private ISelectionTypeProvider provider;

    public ComboGroup(Composite parent) {
        this.combo = new Combo(parent, 12);
    }

    @Override
    public void setInput(Object input) {
        this.objects = this.provider.getElements(input);
        int selectedIndex = 0;
        int i = 0;
        while (i < this.objects.length) {
            this.combo.add(this.provider.getText(this.objects[i]));
            if (this.provider.getSelectionStat(this.objects[i])) {
                selectedIndex = i;
            }
            ++i;
        }
        this.combo.select(selectedIndex);
    }

    @Override
    public Object[] getSelection() {
        int i = this.combo.getSelectionIndex();
        if (i == -1) {
            return new Object[0];
        }
        return new Object[]{this.objects[i]};
    }

    @Override
    public ArrayList<ObjectWithStat> getObjectsWithSelectionStat() {
        ArrayList<ObjectWithStat> list = new ArrayList<ObjectWithStat>();
        int index = this.combo.getSelectionIndex();
        int i = 0;
        while (i < this.objects.length) {
            if (index == i) {
                list.add(new ObjectWithStat(this.objects[i], true));
            } else {
                list.add(new ObjectWithStat(this.objects[i], false));
            }
            ++i;
        }
        return list;
    }

    public Combo getCombo() {
        return this.combo;
    }

    @Override
    public ISelectionTypeProvider getProvider() {
        return this.provider;
    }

    @Override
    public void setProvider(ISelectionTypeProvider provider) {
        this.provider = provider;
    }

    @Override
    public void dispose() {
        this.combo.dispose();
    }

    @Override
    public void setSize(int width, int height) {
        this.combo.setSize(width, height);
    }

    @Override
    public Control getControl() {
        return this.combo;
    }

    @Override
    public void setWidgetBackgroudColor(Color color) {
        this.combo.setBackground(color);
    }

    @Override
    public void addInputValueChangeListener(final InputValueChangeListener listener) {
        this.combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                listener.InputValueChangeEvent();
            }
        });
    }
}

