/*
 * Decompiled with CFR 0.152.
 */
package com.sixthhosp.gcmpa.tools.parameters.widgets;

import com.sixthhosp.gcmpa.tools.parameters.widgets.IWidgetMethods;
import com.sixthhosp.gcmpa.tools.parameters.widgets.InputValueChangeListener;
import java.io.File;
import java.util.ArrayList;
import org.apache.commons.lang.StringUtils;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class FileChooseWidget
implements IWidgetMethods {
    public static String SEP = "__SEP__";
    private Composite composite;
    private Text text;
    private Button button;
    private InputValueChangeListener listener;
    private boolean multiple;
    private String absolutePath;
    protected String[] extensions;

    public FileChooseWidget(Composite parent, boolean multiple, String[] extension) {
        this.extensions = extension;
        this.multiple = multiple;
        this.composite = new Composite(parent, 0);
        this.composite.setLayout((Layout)new GridLayout(2, true));
        this.text = new Text(this.composite, 2056);
        GridData data = new GridData();
        data.widthHint = 400;
        this.text.setLayoutData((Object)data);
        this.button = new Button(this.composite, 8);
        this.button.setText("Browse...");
        this.button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (!FileChooseWidget.this.multiple) {
                    FileDialog fileDialog = new FileDialog(FileChooseWidget.this.button.getShell(), 4096);
                    fileDialog.setText("Select A File");
                    fileDialog.setFilterExtensions(FileChooseWidget.this.extensions);
                    String path = fileDialog.open();
                    if (path != null) {
                        FileChooseWidget.this.absolutePath = path;
                        FileChooseWidget.this.setDefaultText(FileChooseWidget.this.absolutePath);
                        if (FileChooseWidget.this.listener != null) {
                            FileChooseWidget.this.listener.InputValueChangeEvent();
                        }
                    }
                } else {
                    FileDialog fileDialog = new FileDialog(FileChooseWidget.this.button.getShell(), 4098);
                    fileDialog.setText("Select Multiple Files");
                    fileDialog.setFilterExtensions(FileChooseWidget.this.extensions);
                    String path = fileDialog.open();
                    if (path != null) {
                        Object[] fileNames = fileDialog.getFileNames();
                        String dir = fileDialog.getFilterPath();
                        ArrayList<String> files = new ArrayList<String>();
                        Object[] objectArray = fileNames;
                        int n = fileNames.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String fileName = objectArray[n2];
                            files.add(new File(String.valueOf(dir) + File.separator + fileName).getAbsolutePath());
                            ++n2;
                        }
                        FileChooseWidget.this.absolutePath = StringUtils.join(files, (String)SEP);
                        String display = StringUtils.join((Object[])fileNames, (String)" | ");
                        FileChooseWidget.this.setDefaultText(display);
                        if (FileChooseWidget.this.listener != null) {
                            FileChooseWidget.this.listener.InputValueChangeEvent();
                        }
                    }
                }
            }
        });
    }

    @Override
    public boolean isEmpty() {
        return StringUtils.isBlank((String)this.absolutePath);
    }

    public void setDefaultFile(File file) {
        this.absolutePath = file.getAbsolutePath();
        this.setDefaultText(this.absolutePath);
    }

    public void setDefaultText(String string) {
        if (string.length() > 500) {
            string = string.substring(0, 500);
            string = String.valueOf(string) + "...etc.";
        }
        this.text.setText(string);
    }

    public void setPath(String file) {
        this.absolutePath = file;
    }

    public String getAbsolutePath() {
        return this.absolutePath;
    }

    public Button getButton() {
        return this.button;
    }

    @Override
    public Control getControl() {
        return this.composite;
    }

    @Override
    public void dispose() {
        this.composite.dispose();
    }

    @Override
    public void setWidgetBackgroudColor(Color color) {
        this.composite.setBackground(color);
        this.text.setBackground(color);
    }

    public void addInputValueChangeListener(InputValueChangeListener listener) {
        this.listener = listener;
    }
}

