/*
 * Decompiled with CFR 0.152.
 */
package com.sixthhosp.gcmpa.tools.parameters.widgets;

import com.sixthhosp.gcmpa.tools.parameters.widgets.ISelectionTypeProvider;
import com.sixthhosp.gcmpa.tools.parameters.widgets.InputValueChangeListener;
import com.sixthhosp.gcmpa.tools.parameters.widgets.ObjectWithStat;
import com.sixthhosp.gcmpa.tools.parameters.widgets.SelectionWidget;
import java.util.ArrayList;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class RadioGroup
extends SelectionWidget {
    private Composite group;
    private Button[] buttons;
    private Object[] objects;
    private ISelectionTypeProvider provider;

    public RadioGroup(Composite parent) {
        this.group = new Composite(parent, 0);
        FillLayout layout = new FillLayout(512);
        layout.spacing = 3;
        this.group.setLayout((Layout)layout);
    }

    @Override
    public void setInput(Object input) {
        this.objects = this.provider.getElements(input);
        this.buttons = new Button[this.objects.length];
        int selectedIndex = 0;
        int i = 0;
        while (i < this.objects.length) {
            this.buttons[i] = new Button(this.group, 16400);
            this.buttons[i].setText(this.provider.getText(this.objects[i]));
            if (this.provider.getSelectionStat(this.objects[i])) {
                selectedIndex = i;
            }
            ++i;
        }
        this.buttons[selectedIndex].setSelection(true);
    }

    @Override
    public Object[] getSelection() {
        ArrayList<Object> list = new ArrayList<Object>();
        int i = 0;
        while (i < this.objects.length) {
            if (this.buttons[i].getSelection()) {
                list.add(this.objects[i]);
            }
            ++i;
        }
        return list.toArray();
    }

    @Override
    public ArrayList<ObjectWithStat> getObjectsWithSelectionStat() {
        ArrayList<ObjectWithStat> list = new ArrayList<ObjectWithStat>();
        int i = 0;
        while (i < this.objects.length) {
            if (this.buttons[i].getSelection()) {
                list.add(new ObjectWithStat(this.objects[i], true));
            } else {
                list.add(new ObjectWithStat(this.objects[i], false));
            }
            ++i;
        }
        return list;
    }

    public Composite getGroup() {
        return this.group;
    }

    @Override
    public ISelectionTypeProvider getProvider() {
        return this.provider;
    }

    @Override
    public void setProvider(ISelectionTypeProvider provider) {
        this.provider = provider;
    }

    @Override
    public void dispose() {
        this.group.dispose();
    }

    @Override
    public void setSize(int width, int height) {
        this.group.setSize(width, height);
    }

    @Override
    public Control getControl() {
        return this.group;
    }

    @Override
    public void setWidgetBackgroudColor(Color color) {
        this.group.setBackground(color);
        Button[] buttonArray = this.buttons;
        int n = this.buttons.length;
        int n2 = 0;
        while (n2 < n) {
            Button button = buttonArray[n2];
            button.setBackground(color);
            ++n2;
        }
    }

    @Override
    public void addInputValueChangeListener(final InputValueChangeListener listener) {
        int i = 0;
        while (i < this.buttons.length) {
            this.buttons[i].addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    listener.InputValueChangeEvent();
                }
            });
            ++i;
        }
    }
}

