/*
 * Decompiled with CFR 0.152.
 */
package com.sixthhosp.gcmpa.tools.parameters.widgets;

import com.sixthhosp.gcmpa.tools.parameters.widgets.IWidgetMethods;
import com.sixthhosp.gcmpa.tools.parameters.widgets.InputValueChangeListener;
import org.apache.commons.lang.StringUtils;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;

public class TextWidget
implements IWidgetMethods {
    private int width;
    private int height;
    private String defaultText;
    private Composite composite;
    private Text text;

    public TextWidget(Composite parent, String defaultString, String size, boolean isArea) {
        this.composite = new Composite(parent, 0);
        this.defaultText = defaultString == null ? "" : defaultString;
        if (isArea) {
            String[] strings = size.split("x");
            this.height = Integer.parseInt(strings[0]);
            this.width = Integer.parseInt(strings[1]);
            this.text = new Text(this.composite, 2050);
            GC gc = new GC((Drawable)this.text);
            FontMetrics fontMetrics = gc.getFontMetrics();
            int widthPixel = this.width * (fontMetrics.getAverageCharWidth() + 1);
            int heightPixel = this.height * fontMetrics.getHeight();
            gc.dispose();
            this.text.setSize(this.text.computeSize(widthPixel, heightPixel));
            this.text.setText(this.defaultText);
        } else {
            this.width = Integer.parseInt(size);
            this.height = 1;
            this.text = new Text(this.composite, 2052);
            GC gc = new GC((Drawable)this.text);
            FontMetrics fontMetrics = gc.getFontMetrics();
            int widthPixel = this.width * (fontMetrics.getAverageCharWidth() + 1);
            int heightPixel = this.height * fontMetrics.getHeight();
            gc.dispose();
            this.text.setSize(this.text.computeSize(widthPixel, heightPixel));
            this.text.setText(this.defaultText);
        }
    }

    @Override
    public boolean isEmpty() {
        return StringUtils.isBlank((String)this.text.getText());
    }

    public void addInputValueChangeListener(final InputValueChangeListener listener) {
        this.text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                listener.InputValueChangeEvent();
            }
        });
    }

    public String getInputString() {
        return this.text.getText();
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public Text getText() {
        return this.text;
    }

    public String getDefaultText() {
        return this.defaultText;
    }

    @Override
    public Control getControl() {
        return this.composite;
    }

    @Override
    public void dispose() {
        this.composite.dispose();
    }

    @Override
    public void setWidgetBackgroudColor(Color color) {
        this.composite.setBackground(color);
        this.text.setBackground(color);
    }
}

