/*
 * Decompiled with CFR 0.152.
 */
package com.sixthhosp.gcmpa.views;

import com.sixthhosp.gcmpa.editors.HtmlEditor;
import com.sixthhosp.gcmpa.editors.ei.HtmlEditorInput;
import com.sixthhosp.gcmpa.views.filetree.FileTreeViewer;
import com.sixthhosp.gcmpa.views.filetree.actions.CollapseAllAction;
import com.sixthhosp.gcmpa.views.filetree.actions.CopyAction;
import com.sixthhosp.gcmpa.views.filetree.actions.DeleteAction;
import com.sixthhosp.gcmpa.views.filetree.actions.OpenAction;
import com.sixthhosp.gcmpa.views.filetree.actions.OpenResultFolderAction;
import com.sixthhosp.gcmpa.views.filetree.actions.RefreshAction;
import java.io.File;
import org.eclipse.core.commands.IHandler;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.commands.ActionHandler;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.part.ViewPart;

public class FilesView
extends ViewPart {
    public static final String ID = "com.sixthhosp.gcmpa.views.filesview";
    private FileTreeViewer fileTreeViewer;
    private OpenAction openAction;
    private RefreshAction refreshAction;
    private CollapseAllAction collapseAllAction;
    private DeleteAction deleteAction;
    private CopyAction copyAction;
    private OpenResultFolderAction openResultFolderAction;

    public void createPartControl(Composite parent) {
        this.fileTreeViewer = new FileTreeViewer(parent, 770);
        this.fileTreeViewer.setInput(null);
        this.makeActions();
        this.hookContextMenu();
        this.hookDoubleClickAction();
        this.contributeToActionBars();
        IWorkbenchPage page = this.getSite().getPage();
        IPartListener2 listener = new IPartListener2(){

            public void partVisible(IWorkbenchPartReference partRef) {
            }

            public void partOpened(IWorkbenchPartReference partRef) {
            }

            public void partInputChanged(IWorkbenchPartReference partRef) {
            }

            public void partHidden(IWorkbenchPartReference partRef) {
            }

            public void partDeactivated(IWorkbenchPartReference partRef) {
            }

            public void partClosed(IWorkbenchPartReference partRef) {
            }

            public void partBroughtToTop(IWorkbenchPartReference partRef) {
                IWorkbenchPart part = partRef.getPart(true);
                if (part instanceof HtmlEditor) {
                    HtmlEditor editor = (HtmlEditor)part;
                    HtmlEditorInput editorInput = (HtmlEditorInput)editor.getEditorInput();
                    FilesView.this.fileTreeViewer.setInput(new File(editorInput.getXmlTask().getOutputsfolderpath()));
                }
            }

            public void partActivated(IWorkbenchPartReference partRef) {
            }
        };
        page.addPartListener(listener);
    }

    private void makeActions() {
        IStatusLineManager statusline = this.getViewSite().getActionBars().getStatusLineManager();
        this.openAction = new OpenAction(this.fileTreeViewer);
        this.refreshAction = new RefreshAction(this.fileTreeViewer);
        this.collapseAllAction = new CollapseAllAction(this.fileTreeViewer);
        this.deleteAction = new DeleteAction(this.fileTreeViewer, statusline);
        this.copyAction = new CopyAction(this.fileTreeViewer, statusline);
        this.openResultFolderAction = new OpenResultFolderAction(this.fileTreeViewer);
        IHandlerService handlerService = (IHandlerService)this.getSite().getService(IHandlerService.class);
        handlerService.activateHandler("org.eclipse.ui.edit.copy", (IHandler)new ActionHandler((IAction)this.copyAction));
        handlerService.activateHandler("org.eclipse.ui.edit.delete", (IHandler)new ActionHandler((IAction)this.deleteAction));
        handlerService.activateHandler("org.eclipse.ui.file.refresh", (IHandler)new ActionHandler((IAction)this.refreshAction));
    }

    private void hookContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        this.fillContextMenu((IMenuManager)menuMgr);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                IStructuredSelection selection = (IStructuredSelection)FilesView.this.fileTreeViewer.getSelection();
                if (selection.size() == 1) {
                    FilesView.this.openAction.setEnabled(true);
                } else {
                    FilesView.this.openAction.setEnabled(false);
                }
                if (!selection.isEmpty()) {
                    FilesView.this.copyAction.setEnabled(true);
                    FilesView.this.deleteAction.setEnabled(true);
                } else {
                    FilesView.this.copyAction.setEnabled(false);
                    FilesView.this.deleteAction.setEnabled(false);
                }
            }
        });
        Menu menu = menuMgr.createContextMenu(this.fileTreeViewer.getControl());
        this.fileTreeViewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.fileTreeViewer);
    }

    private void fillContextMenu(IMenuManager manager) {
        manager.add((IAction)this.openAction);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.copyAction);
        manager.add((IAction)this.deleteAction);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.openResultFolderAction);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.collapseAllAction);
        manager.add((IAction)this.refreshAction);
        manager.add((IContributionItem)new Separator("additions"));
    }

    private void hookDoubleClickAction() {
        this.fileTreeViewer.addDoubleClickListener(this.openAction);
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.openResultFolderAction);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.refreshAction);
    }

    public void setFocus() {
        this.fileTreeViewer.getControl().setFocus();
    }

    public FileTreeViewer getFileTreeViewer() {
        return this.fileTreeViewer;
    }
}

