/*
 * Decompiled with CFR 0.152.
 */
package com.sixthhosp.gcmpa.views;

import com.sixthhosp.gcmpa.tasks.XmlTask;
import com.sixthhosp.gcmpa.views.FilesView;
import com.sixthhosp.gcmpa.views.filetree.FileTreeViewer;
import com.sixthhosp.gcmpa.views.tasktree.TaskTableViewer;
import com.sixthhosp.gcmpa.views.tasktree.actions.DeleteAction;
import com.sixthhosp.gcmpa.views.tasktree.actions.DeleteAllAction;
import com.sixthhosp.gcmpa.views.tasktree.actions.OpenLogAction;
import com.sixthhosp.gcmpa.views.tasktree.actions.OpenResultAction;
import com.sixthhosp.gcmpa.views.tasktree.actions.OpenResultFolderAction;
import com.sixthhosp.gcmpa.views.tasktree.actions.OpenRootFolderAction;
import com.sixthhosp.gcmpa.views.tasktree.actions.ReRunAction;
import com.sixthhosp.gcmpa.views.tasktree.actions.StopAction;
import com.sixthhosp.gcmpa.views.tasktree.actions.StopAllAction;
import com.sixthhosp.gcmpa.views.tasktree.provider.TaskLableProvider;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.part.ViewPart;

public class TasksView
extends ViewPart {
    public static final String ID = "com.sixthhosp.gcmpa.views.taskview";
    private TableViewer taskTableViewer;
    private OpenResultAction openResultAction;
    private ReRunAction reRunAction;
    private StopAction stopAction;
    private StopAllAction stopAllAction;
    private OpenLogAction openLogAction;
    private OpenResultFolderAction openResultFolderAction;
    private DeleteAction deleteAction;
    private DeleteAllAction deleteAllAction;
    private OpenRootFolderAction openRootFolderAction;

    public void createPartControl(Composite parent) {
        this.taskTableViewer = new TaskTableViewer(parent, 66308);
        IBaseLabelProvider labelProvider = this.taskTableViewer.getLabelProvider();
        TaskLableProvider taskLableProvider = (TaskLableProvider)labelProvider;
        taskLableProvider.startDynamicRunningStat();
        this.makeActions();
        this.hookContextMenu();
        this.hookMouseAction();
        this.hookDoubleClickAction();
    }

    private void makeActions() {
        IViewPart viewPart = this.getSite().getPage().findView("com.sixthhosp.gcmpa.views.filesview");
        Assert.isNotNull((Object)viewPart);
        FileTreeViewer fileTreeViewer = ((FilesView)viewPart).getFileTreeViewer();
        this.openResultAction = new OpenResultAction(this.taskTableViewer, fileTreeViewer);
        this.reRunAction = new ReRunAction(this.taskTableViewer);
        this.stopAction = new StopAction(this.taskTableViewer);
        this.stopAllAction = new StopAllAction(this.taskTableViewer);
        this.openLogAction = new OpenLogAction(this.taskTableViewer);
        this.openResultFolderAction = new OpenResultFolderAction(this.taskTableViewer);
        this.deleteAction = new DeleteAction(this.taskTableViewer);
        this.deleteAllAction = new DeleteAllAction(this.taskTableViewer);
        this.openRootFolderAction = new OpenRootFolderAction(this.taskTableViewer);
    }

    private void hookContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.add((IAction)this.openResultAction);
        menuMgr.add((IAction)this.openResultFolderAction);
        menuMgr.add((IAction)this.openRootFolderAction);
        menuMgr.add((IAction)this.openLogAction);
        menuMgr.add((IContributionItem)new Separator());
        menuMgr.add((IAction)this.reRunAction);
        menuMgr.add((IContributionItem)new Separator());
        menuMgr.add((IAction)this.stopAction);
        menuMgr.add((IAction)this.stopAllAction);
        menuMgr.add((IContributionItem)new Separator());
        menuMgr.add((IAction)this.deleteAction);
        menuMgr.add((IAction)this.deleteAllAction);
        menuMgr.add((IContributionItem)new Separator("additions"));
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                IStructuredSelection selection = (IStructuredSelection)TasksView.this.taskTableViewer.getSelection();
                if (selection.size() != 1) {
                    TasksView.this.openResultAction.setEnabled(false);
                    TasksView.this.openResultFolderAction.setEnabled(false);
                    TasksView.this.reRunAction.setEnabled(false);
                    TasksView.this.stopAction.setEnabled(false);
                    TasksView.this.openLogAction.setEnabled(false);
                    TasksView.this.deleteAction.setEnabled(false);
                } else {
                    Object object = selection.getFirstElement();
                    XmlTask xmlTask = (XmlTask)object;
                    if (xmlTask.isAllFinished()) {
                        if (xmlTask.getTaskstate().equals("Finished")) {
                            TasksView.this.openResultAction.setEnabled(true);
                            TasksView.this.openResultFolderAction.setEnabled(true);
                        } else {
                            TasksView.this.openResultAction.setEnabled(false);
                            TasksView.this.openResultFolderAction.setEnabled(false);
                        }
                        TasksView.this.reRunAction.setEnabled(true);
                        TasksView.this.openLogAction.setEnabled(true);
                        TasksView.this.deleteAction.setEnabled(true);
                    } else {
                        TasksView.this.openResultAction.setEnabled(false);
                        TasksView.this.openResultFolderAction.setEnabled(false);
                        TasksView.this.reRunAction.setEnabled(false);
                        TasksView.this.openLogAction.setEnabled(false);
                        TasksView.this.deleteAction.setEnabled(false);
                    }
                    if (xmlTask.canStop()) {
                        TasksView.this.stopAction.setEnabled(true);
                    } else {
                        TasksView.this.stopAction.setEnabled(false);
                    }
                }
            }
        });
        Menu menu = menuMgr.createContextMenu(this.taskTableViewer.getControl());
        this.taskTableViewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.taskTableViewer);
    }

    private void hookMouseAction() {
    }

    private void hookDoubleClickAction() {
        this.taskTableViewer.addDoubleClickListener((IDoubleClickListener)this.openResultAction);
    }

    public void setFocus() {
        this.taskTableViewer.getTable().setFocus();
    }

    public TableViewer getTaskTableViewer() {
        return this.taskTableViewer;
    }
}

