/*
 * Decompiled with CFR 0.152.
 */
package com.sixthhosp.gcmpa.views;

import com.sixthhosp.gcmpa.tools.Tool;
import com.sixthhosp.gcmpa.tools.ToolSectionLabel;
import com.sixthhosp.gcmpa.views.tooltree.ToolTreeViewer;
import com.sixthhosp.gcmpa.views.tooltree.actions.CollapseAllAction;
import com.sixthhosp.gcmpa.views.tooltree.actions.OpenHelpAction;
import com.sixthhosp.gcmpa.views.tooltree.actions.OpenToolAction;
import org.eclipse.core.commands.IHandler;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.commands.ActionHandler;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.dialogs.PatternFilter;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.part.ViewPart;

public class ToolsView
extends ViewPart {
    public static final String ID = "com.sixthhosp.gcmpa.views.toolsview";
    private TreeViewer toolTreeViewer;
    private OpenHelpAction openHelpAction;
    private OpenToolAction openToolAction;
    private CollapseAllAction collapseAllAction;

    public void createPartControl(Composite parent) {
        PatternFilter patternFilter = new PatternFilter();
        ToolTreeViewer filteredTreeViewer = new ToolTreeViewer(parent, 772, patternFilter, true);
        this.toolTreeViewer = filteredTreeViewer.getToolTreeViewer();
        this.makeActions();
        this.hookContextMenu();
        this.hookMouseAction();
        this.hookDoubleClickAction();
    }

    private void makeActions() {
        this.openHelpAction = new OpenHelpAction(this.toolTreeViewer);
        IHandlerService handlerService = (IHandlerService)this.getSite().getService(IHandlerService.class);
        handlerService.activateHandler("com.sixthhosp.gcmpa.toolhelp", (IHandler)new ActionHandler((IAction)this.openHelpAction));
        this.openToolAction = new OpenToolAction(this.toolTreeViewer);
        this.collapseAllAction = new CollapseAllAction(this.toolTreeViewer);
    }

    private void hookContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.add((IAction)this.openToolAction);
        menuMgr.add((IContributionItem)new Separator());
        menuMgr.add((IAction)this.openHelpAction);
        menuMgr.add((IContributionItem)new Separator());
        menuMgr.add((IAction)this.collapseAllAction);
        menuMgr.add((IContributionItem)new Separator("additions"));
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                IStructuredSelection selection = (IStructuredSelection)ToolsView.this.toolTreeViewer.getSelection();
                if (selection.size() != 1) {
                    ToolsView.this.openToolAction.setEnabled(false);
                    ToolsView.this.openHelpAction.setEnabled(false);
                } else {
                    Object object = selection.getFirstElement();
                    if (object instanceof Tool) {
                        ToolsView.this.openToolAction.setEnabled(true);
                        ToolsView.this.openHelpAction.setEnabled(true);
                    } else {
                        ToolsView.this.openToolAction.setEnabled(false);
                        ToolsView.this.openHelpAction.setEnabled(false);
                    }
                }
            }
        });
        Menu menu = menuMgr.createContextMenu(this.toolTreeViewer.getControl());
        this.toolTreeViewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.toolTreeViewer);
    }

    private void hookMouseAction() {
        this.toolTreeViewer.getTree().addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                IStructuredSelection selection = (IStructuredSelection)ToolsView.this.toolTreeViewer.getSelection();
                Object object = selection.getFirstElement();
                if (object instanceof ToolSectionLabel) {
                    ToolsView.this.toolTreeViewer.setSelection(null);
                }
            }
        });
    }

    private void hookDoubleClickAction() {
        this.toolTreeViewer.addDoubleClickListener((IDoubleClickListener)this.openToolAction);
    }

    public void setFocus() {
        this.toolTreeViewer.getTree().setFocus();
    }
}

